/*********************************************************************/
/* Project Name: RGPIO.mcp                                           */
/* Source fle name: RGPIO.c                                          */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: RGPIO                                                     */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: This firmware shows how to configure the RGPIO       */
/* module on the V1 MCU.                                             */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */  
}

void GPIO_Init(void) { 
  
 PTEDD = 0x03;          /* Configure PTE0 and PTE1 pins as outputs */
 PTED = 0x00;           /* Put 0's in PTE port */
}

void RGPIO_Init(void) { 
  
 RGPIO_DIR = 0x0080;          /* Configure PTE7 pin as output */
 RGPIO_ENB = 0x0080;          /* Configure PTE7 as RGPIO pin */
}


/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  RGPIO_Init();     /* Function that initializes the RGPIO module */
  
  EnableInterrupts; /* enable interrupts */
  
  for(;;) {

  PTED_PTED1 ^= 1;      /* Toggles a PTE1. This instruction is executed in 18 CPU cycles */
  PTED ^= 0x01;         /* Toggles a PTE0. This instruction is executed in 5 CPU cycles */
  RGPIO_TOG = 0x0080;   /* Toggles PTE7. This instruction is executed in 2 CPU cycles */
  
  } /* loop forever */
  /* please make sure that you never leave this function */
}

