/*********************************************************************/
/* Project Name: ACMP.mcp                                            */
/* Source fle name: ACMP.c                                           */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: ACMP                                                      */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The PTC7 pin is the input for ACMP module. If the    */
/* ACMP interrupt is generated the PTE0 toggles.                     */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */


/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */ 
 SCGC1 = 0x00;          /* Disable Bus clock to unused peripherals */
 SCGC2 = 0x08;          /* Bus Clock to ACMP module is enabled */
}

void GPIO_Init(void) { 
  
 PTEDD = 0x01;          /* Configure PTE0 as output */
 PTED = 0x00;           /* Put 0's in port E (this will turn the LEDs off) */
}

void ACMP_configuration (void) {

 ACMP2SC = 0xC3;        /* ACMP module enable. Internal reference selected. Comparator output rising */
}                       /* or falling edge */


/*********************************************************************
*  Main Function                                                     *
*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */         
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  ACMP_configuration(); /* Function that initializes the ACMP module */

  EnableInterrupts; /* enable interrupts */
  ACMP2SC_ACIE = 1; /* enable the interrupt from the ACMP */

  for(;;) {
    } /* loop forever */
  /* please make sure that you never leave this function */
}


/*********************************************************************
*  Interrupt Service Routines                                        *
*********************************************************************/

void interrupt VectorNumber_Vacmpx ACMP_ISR(void) {

 ACMP2SC_ACF = 1;    /* Clear ACMP flag */
 
 PTED_PTED0 ^= 1;    /* Toggle PTE0 */
}