/*********************************************************************/
/* Project Name: RTC.mcp                                             */
/* Source fle name: RTC.c                                            */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: RTC                                                       */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The MCU interrupts every second and PTE port is      */
/* toggle                                                            */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */


/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */ 
 SCGC2 = 0x04;          /* Bus Clock to the RTC module is enable */
}

void GPIO_Init(void) { 
  
 PTEDD = 0xFF;          /* Configure port E as outputs */
 PTED = 0x00;           /* Put 0's in port E */
}


void RTC_configuration (void) {
  
 RTCSC = 0x0F;          /* RTCPS configure prescaler period every 1s */
 RTCMOD = 0x00;         /* RTCMOD configure to interrupt every 1s */
}

/*********************************************************************
*  Main Function                                                     *
*********************************************************************/

void main(void) {

  MCU_Init();           /* Function that initializes the MCU */
  GPIO_Init();          /* Function that initializes the Ports of the MCU */
  RTC_configuration();  /* Function that initializes the RTC module */

  EnableInterrupts; /* enable interrupts */
  
  RTCSC_RTIE = 1;   /* Enable RTC interrupt */
  for(;;) {
 
  } /* loop forever */
  /* please make sure that you never leave this function */
}


/*********************************************************************
*  Interrupt Service Routines                                        *
*********************************************************************/

void interrupt VectorNumber_Vrtc RTC_ISR(void) {
                                                                
 RTCSC = RTCSC | 0x80;        /* Clear the RTC flag */
 PTED ^= 0xFF;                /* Toggles Port E */
} 

                       