/*
 * The Clear BSD License
 * Copyright (c) 2017, NXP Semiconductor, Inc.
 * All rights reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer below) provided
 * that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY THIS LICENSE.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * usb_device_audio_test.c
 *
 */

#include "main.h"

#define MSG_STRING_LEN 80
static char msgString[MSG_STRING_LEN];

extern bool done;

extern ErrorCode_t usbd_init(void);

void usb_device_audio_test_cmd (uint32_t argc, char *argv[])
{
	ErrorCode_t ret = LPC_OK;

	GUI_Clear();

    snprintf(msgString,MSG_STRING_LEN,"\r\nLPC54S018M full speed USB Device Audio Test\r\n");
    GUI_DispString(msgString);
    PRINTF(msgString);
//    snprintf(msgString,MSG_STRING_LEN,"Make sure Jumper JP9 is set to 2-3\r\n");
//    GUI_DispString(msgString);
//    PRINTF(msgString);
    snprintf(msgString,MSG_STRING_LEN,"Connect a PC to USB FS USB connector (J3)\r\n");
    GUI_DispString(msgString);
    PRINTF(msgString);
    snprintf(msgString,MSG_STRING_LEN,"Connect Speaker to Line Out and Mic to Line In\r\n");
    GUI_DispString(msgString);
    PRINTF(msgString);
    snprintf(msgString,MSG_STRING_LEN,"Board will enumerate as an audio input/output device on host computer\r\n");
    GUI_DispString(msgString);
    PRINTF(msgString);
    snprintf(msgString,MSG_STRING_LEN,"\r\nPress User button to end test and go to Self-Test main menu\r\n");
    GUI_DispString(msgString);
    PRINTF(msgString);

    /* Initialize USB subsystem */
    ret = usbd_init();

    if (ret != LPC_OK)
    {
    	PRINTF("Fail to init USB device\r\n");
    }
    else while (1U)
    {
        Codec_Tasks();
        __WFI();
		if (done)
			break;
    }

	done = false;
    GUI_Display_Prompt();
    cli_display_prompt();
}

