/*
 * The Clear BSD License
 * Copyright (c) 2017, NXP Semiconductor, Inc.
 * All rights reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer below) provided
 * that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY THIS LICENSE.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * led_button_test.c
 *
 */

#include "main.h"

#define MSG_STRING_LEN 80
static char msgString[MSG_STRING_LEN];

#define APP_BOARD_TEST_LED3_PORT 2U
#define APP_BOARD_TEST_LED3_PIN 2U
#define APP_BOARD_TEST_LED2_PORT 3U
#define APP_BOARD_TEST_LED2_PIN 3U
#define APP_BOARD_TEST_LED1_PORT 3U
#define APP_BOARD_TEST_LED1_PIN 14U
#define ISP_SW_PORT 0U
#define ISP2_SW_PIN 6U
#define ISP1_SW_PIN 5U
#define ISP0_SW_PIN 4U
#define USER_SW_PORT 1U
#define USER_SW_PIN 1U

extern bool done;

void delay(void)
{
    volatile uint32_t i = 0;
    for (i = 0; i < 1000000; ++i)
    {
        __asm("NOP"); /* delay */
    }
}

void led_button_test_cmd (uint32_t argc, char *argv[])
{
    uint32_t isp_port_state = 0;

	BOARD_InitBUTTONs();
	BOARD_InitLEDs();

    gpio_pin_config_t led_config =
    {
        kGPIO_DigitalOutput, 0,
    };

    GUI_Clear();

    snprintf(msgString,MSG_STRING_LEN,"\r\nLPC54018 LEDs & Buttons Test\r\n");
    GUI_DispString(msgString);
    PRINTF(msgString);
    snprintf(msgString,MSG_STRING_LEN,"LEDs will flash on and off while a button is held down:\r\n\r");
    GUI_DispString(msgString);
    PRINTF(msgString);
    snprintf(msgString,MSG_STRING_LEN,"Press ISP2 for LED1, ISP1 for LED2, ISP0 for LED3.");
    GUI_DispString(msgString);
    PRINTF(msgString);
    snprintf(msgString,MSG_STRING_LEN,"\r\nPress User button to end test and go to Self-Test main menu\n");
    GUI_DispString(msgString);
    PRINTF(msgString);

    /* Init switch GPIO ports. */
    GPIO_PortInit(GPIO, ISP_SW_PORT);

    /* Init output LED GPIO. */
    GPIO_PortInit(GPIO, APP_BOARD_TEST_LED3_PORT);
    GPIO_PortInit(GPIO, APP_BOARD_TEST_LED2_PORT);
    GPIO_PortInit(GPIO, APP_BOARD_TEST_LED1_PORT);
    GPIO_PinInit(GPIO, APP_BOARD_TEST_LED3_PORT, APP_BOARD_TEST_LED3_PIN, &led_config);
    GPIO_PinInit(GPIO, APP_BOARD_TEST_LED2_PORT, APP_BOARD_TEST_LED2_PIN, &led_config);
    GPIO_PinInit(GPIO, APP_BOARD_TEST_LED1_PORT, APP_BOARD_TEST_LED1_PIN, &led_config);
    GPIO_PinWrite(GPIO, APP_BOARD_TEST_LED3_PORT, APP_BOARD_TEST_LED3_PIN, 1);
    GPIO_PinWrite(GPIO, APP_BOARD_TEST_LED2_PORT, APP_BOARD_TEST_LED2_PIN, 1);
    GPIO_PinWrite(GPIO, APP_BOARD_TEST_LED1_PORT, APP_BOARD_TEST_LED1_PIN, 1);

    /* Port masking */
    GPIO_PortMaskedSet(GPIO, ISP_SW_PORT, ISP2_SW_PIN|ISP1_SW_PIN|ISP0_SW_PIN);

    while (1)
    {
        isp_port_state = GPIO_PortMaskedRead(GPIO, ISP_SW_PORT);

        if (!(isp_port_state & (1 << ISP0_SW_PIN)))
        {
            GPIO_PortToggle(GPIO, APP_BOARD_TEST_LED3_PORT, 1u << APP_BOARD_TEST_LED3_PIN);
        }
        if (!(isp_port_state & (1 << ISP1_SW_PIN)))
        {
            GPIO_PortToggle(GPIO, APP_BOARD_TEST_LED2_PORT, 1u << APP_BOARD_TEST_LED2_PIN);
        }
        if (!(isp_port_state & (1 << ISP2_SW_PIN)))
        {
            GPIO_PortToggle(GPIO, APP_BOARD_TEST_LED1_PORT, 1u << APP_BOARD_TEST_LED1_PIN);
        }
        delay();
        if (done)
        	break;
    }
    GPIO_PortMaskedSet(GPIO, ISP_SW_PORT, 0xFFFFFFFF);
    done = false;
    GUI_Display_Help();
    cli_display_prompt();
}

