#include "TempControl.h"
#include "LED1.h"
  /* Including shared modules, which are used in the whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Cpu.h"

void vfnLL64_PE_Demo_InitGPIO(void);

#pragma CONST_SEG NON_VOLATILE_DATA
const UINT8 CoolingSetPoints[DAYS_OF_WEEK] = 
{
  23,    //Sunday
  23,    //Monday
  23,    //Tuesday
  23,    //Wednesday
  23,    //Thursday
  23,    //Friday
  23     //Saturday
};

#pragma CONST_SEG NON_VOLATILE_DATA
const UINT8 HeatingSetPoints[DAYS_OF_WEEK] = 
{
  20,    //Sunday
  20,    //Monday
  20,    //Tuesday
  20,    //Wednesday
  20,    //Thursday
  20,    //Friday
  20     //Saturday
};
#pragma CONST_SEG DEFAULT

UINT8 gu8HoldTemperature;
UINT8 gu8HVACStatus;

void vfnTempControlInit(void)
{
  //vfnThermostat_InitGPIO();    // make sure the i/o mapping is aligned ????
  FlashInit();
  CopyInRAM();
}

void vfnThermostat_InitGPIO(void)
{
  
  HEAT_OFF();
  COOL_OFF();
  VENT_OFF();
  
    PTAPE_PTAPE4 = 1;
    PTAPE_PTAPE5 = 1;
    PTADD_PTADD4 = 0;
    PTADD_PTADD5 = 0;

}

void vfnThermostatResetOutputs(void)
{
  HEAT_OFF();
  
  COOL_OFF();
  
  VENT_OFF();
}

/*****************************************************************************************************
* \brief    Function to turn on and off the HVAC system 
* \author   Rafael Peralez
* \param    Temperature DayOfWeek
* \return   HVAC_CHANGED_STATUS   HVAC_SAME_STATUS
* \todo     
*/
UINT8 u8ThermostatTempControl(UINT8 Temperature, UINT8 DayOfWeek)
{
  UINT8 CoolSetPoint = CoolingSetPoints[DayOfWeek];
  UINT8 HeatSetPoint = HeatingSetPoints[DayOfWeek];
  UINT8 TempStatus = gu8HVACStatus;
  
  if (FLAG_CHK(HVAC_HOLD_MODE, gu8HVACStatus))
  {
    CoolSetPoint = gu8HoldTemperature;
    HeatSetPoint = gu8HoldTemperature;
  }
  /* When in hold mode the temperature is alerady in either C or F */
  else if (gu8TempMetricSystem == _FAHRENHEIT_)
  {
    CoolSetPoint = (UINT8)((CoolSetPoint * 9) / 5);
    CoolSetPoint += 32;
    HeatSetPoint = (UINT8)((HeatSetPoint * 9) / 5);
    HeatSetPoint += 32;
  }
  
  

  //if (Temperature > CoolingSetPoints[DayOfWeek])
  if (Temperature > CoolSetPoint)
  {
    if (!FLAG_CHK(HVAC_COOLING, gu8HVACStatus))
    {
      COOL_ON();
      FLAG_SET(HVAC_COOLING, gu8HVACStatus);
    }
  }
  else 
  {
    if (FLAG_CHK(HVAC_COOLING, gu8HVACStatus))
    {
      FLAG_CLR(HVAC_COOLING, gu8HVACStatus);
      COOL_OFF();
    }
  }
  
  //if (Temperature < HeatingSetPoints[DayOfWeek])
  if (Temperature < HeatSetPoint)
  {
    if (!FLAG_CHK(HVAC_HEATING, gu8HVACStatus))
    {
      HEAT_ON();
      FLAG_SET(HVAC_HEATING, gu8HVACStatus);
    }
  }
  else 
  {
    if (FLAG_CHK(HVAC_HEATING, gu8HVACStatus))
    {
      FLAG_CLR(HVAC_HEATING, gu8HVACStatus);
      HEAT_OFF();
    }
  }
  
  if ((FAN_SWITCH_ON) || FLAG_CHK((HVAC_HEATING | HVAC_COOLING), gu8HVACStatus))
  {
    if (!FLAG_CHK(HVAC_VENTING, gu8HVACStatus))
    {
      FLAG_SET(HVAC_VENTING, gu8HVACStatus);
      VENT_ON();
    }
  }
  else if ((!FAN_SWITCH_ON) && !(FLAG_CHK((HVAC_HEATING | HVAC_COOLING), gu8HVACStatus)))
  {
    if (FLAG_CHK(HVAC_VENTING, gu8HVACStatus))
    {
      FLAG_CLR(HVAC_VENTING, gu8HVACStatus);
      VENT_OFF();
    }
  }
  
    
  if (TempStatus != gu8HVACStatus)
  {
    return (HVAC_CHANGED_STATUS);
  }
  return (HVAC_SAME_STATUS);
}

void vfnThermostatRunHold(UINT8 HoldTemperature)
{
  /* Toggle Run/Hold Flag */
  gu8HVACStatus ^= (1<<HVAC_HOLD_MODE);

  gu8HoldTemperature = HoldTemperature; 
}

