#include "S08_TOD_Driver.h"

/*********** Global Variables *************/
UINT8 gu8TOD_Status;

/**
  Initialization Steps:
  1. Configure TOD Clock Source
  2. Configure proper TOD Prescaler
  3. Write the TOD Match Register (If needed)
   3.1 Enable Match Functionallity
  4. Enable desired interrupts (Quarter Second, Second, Match)
  5. Enable TOD Clock Output (If needed)
  6. Enable TOD Module
*/
void vfnTOD_Init(UINT8 lu8TOD_ClockSource, UINT8 lu8DesiredInterrupts, UINT8 lu8MatchValue)
{
  /* Disable the module interrupts before starting the configuration */
  TODSC = 0;
  /* Steps 1 & 2 */
  TODC = lu8TOD_ClockSource;
  /* Start Match Register */
  TODM = lu8MatchValue;
  /* Step 4 */
  TODSC = (lu8DesiredInterrupts | TODSC_QSECF_MASK | TODSC_SECF_MASK | TODSC_MTCHF_MASK);
  /* Step 6 */
  TODC_TODEN = 1;
}

