#ifndef __LL64_PE_DEMO_DEFINES__

  #define __LL64_PE_DEMO_DEFINES__
  
  #define BusClockHighSpeed    8388000
  #define BusClockLowSpeed     32768
  
  
  #define DEBUG_ON
  //#undef DEBUG_ON
  
  #define _DEBOUNCE_25msec              1700
  #define _DEBOUNCE_100msec             6800
  #define _DEBOUNCE_150msec             10300
  #define _DEBOUNCE_200msec             13350
  #define _DEBOUNCE_250msec             16400
  #define _DEBOUNCE_500msec             38800
  

  #define TEMPERATURE_DIGITS            2
  #define TEMP_SHIFT                    4
  #define LCD_TEMPERATURE_POS           3
  
  #define HOUR_DIGITS                   3
  #define LCD_HOUR_COLON_BLINK          _LCD_COLON_Blink
  #define LCD_HOURS_POS                 0
  #define LCD_MINUTES_POS               1 
  
  /* Delay in Seconds to show the current Profile */
  #define SHOW_PROGRAM_DELAY            5
  
  
  #define TEMP_MEASUREMENT_WAKEUP       TOD_MATCH_EVENT
  #define CLEAR_TEMP_MEASUREMENT_FLAG   CLEAR_MATCH_EVENT
  
  #define BLINK_ON_TIME                 2  // Times 0.25 Seconds
  

  #ifdef DEBUG_ON
    #define SW_BREAKPOINT()        asm("bgnd")
    
    #define CONFIG_DEBUG_SIGNAL()  PTBDD_PTBDD3 = 1
    #define DEBUG_SIGNAL_ON()      PTBD_PTBD3 = 1
    #define DEBUG_SIGNAL_OFF()     PTBD_PTBD3 = 0
    #define DEBUG_SIGNAL_TOGGLE()  PTBD_PTBD3 ^= 1
    
  #else
    #define SW_BREAKPOINT()   asm("nop")
  #endif


#endif        /* __LL64_PE_DEMO_DEFINES__ */