/******************************************************************************
*                                             COPYRIGHT (c) Freescale 2007   
* FILE NAME: sci_drv.h     REVISION 1.0                                        
*                                                                           
* PURPOSE: Header file for SCI_DRV.C							 
*                                                                           
*******************************************************************************
*******************************************************************************  
**  THIS CODE IS ONLY INTENDED AS AN EXAMPLE FOR THE CODEWARRIOR COMPILER    **  
**      AND THE S08 EVB AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.     **  
**  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE OF SUPPORT.   **  
*******************************************************************************  
*******************************************************************************
*                                                                           
*                                                                           
* DESCRIPTION:  Header file for SCI driver      
*                                                                           
* NOTE:   
*                                                                           
* AUTHOR: Gordon Borland        LOCATION: EKB      LAST EDIT DATE: 08JAN07  
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      	R28318    	08JAN07	    Initial Revision                                     
*                                                                           
******************************************************************************/

/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Freescale does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Freescale */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale */
/* was negligent regarding the  design  or manufacture of the part. Freescale */
/* and the Freescale logo* are registered trademarks of Freescale Ltd.         */
/*****************************************************************************/

#ifndef SCI_DRV_H        /*prevent duplicated includes*/
#define SCI_DRV_H

#include "IO_map.h"
/****************/

#define	OSCCLK_FREQ_KHZ		32768L	/* "L" postfix evaluated as a long value */

#define BUSCLK_FREQ_KHZ_MAX 20000L	/* "L" postfix evaluated as a long value */

	/* Bus frequency in kHz = fosc / 2 */
#define BUSCLK_FREQ_KHZ_OSC		OSCCLK_FREQ_KHZ/2



/* SCI defines */ 
#define TERMINAL_BAUD_RATE	9600
#define SPARE_BAUD_RATE 	9600

#define SCIBD_BAUD_RATE ((BUSCLK_FREQ_KHZ * 10) / (16 * (TERMINAL_BAUD_RATE/100)))


typedef struct				/*sci datastructure	*/
  {
  volatile SCI1BDSTR	SCIBD;	/*WORD - sci baud rate register(s) */
  volatile SCI1C1STR	SCIC1;	/*sci control register 1 */
  volatile SCI1C2STR	SCIC2;	/*sci control register 2 */
  volatile SCI1S1STR	SCIS1;	/*sci status register 1	*/
  volatile SCI1S2STR	SCIS2;	/*sci status register 2	*/
  volatile SCI1C3STR	SCIC3;	/*sci control register 3 */
  volatile SCI1DSTR 	SCID;	/*sci data register low	*/
  }tSCI;
  
#define SCI1 (*(volatile tSCI*) (0x0020))
//define SCI2 (*(volatile tSCI*) (0x0040))

extern tSCI *TerminalPointer; /* Global Variable indicating which SCI is in use */

/* function prototypes */
void SCI_Config(tSCI *, unsigned int);
unsigned char Number_2_ASCII(unsigned char);
unsigned char ASCII_2_Number(unsigned char);
void ByteDisplay(unsigned char);			/* for compatibility */
void DisplayByte(unsigned char); 
void TextDisplay (signed char*);			/* for compatibility */
void DisplayString (unsigned char*);
void PutChar (char);
void NumberDisplay(unsigned long, unsigned char);	/* for compatibility */ 
void DisplayLong(unsigned long, unsigned char); 
void DisplayInt(unsigned int, unsigned char);
char GetChar(void);
char EchoGetChar(void);
 
/* Macros */
#define _CR PutChar(\r)
#define _LF PutChar(\n)
#define NEW_LINE DisplayString("\r\n")
#define CAR_RET DisplayString("\r")
#define FF DisplayString("\f")
#define LF NEW_LINE							/* for compatibility */
#define CR CAR_RET							/* for compatibility */

/* additional common definitions  - others can be found in HIDEF.H*/
#ifndef OFF
#define OFF     0
#endif

#ifndef ON
#define ON      1u
#endif

#ifndef FOREVER
#define FOREVER 1u
#endif

#ifndef FAIL
#define FAIL	1u
#endif

#ifndef PASS
#define PASS    0u
#endif

#endif /* SCI_DRV_H */
