#ifndef __TEMP_CONTROL__

  #define __TEMP_CONTROL__
  
  #include "derivative.h"
  #include "FslTypes.h"
  #include "S08_Flash.h"
  #include "TempMeasurement.h"
  #include "LED2.h"
  #include "LED3.h"
  #include "LED4.h"

  #define HVAC_OUT              1
  #define HVAC_IN               0
  
  #define HVAC_PIN_OFF          0
  #define HVAC_PIN_ON           1
  
  #define HVAC_CHANGED_STATUS   1
  #define HVAC_SAME_STATUS      0
  
  #ifndef DAYS_OF_WEEK
    #define DAYS_OF_WEEK        7
  #endif
  
  typedef enum
  {
    HVAC_HEATING,
    HVAC_VENTING,
    HVAC_COOLING,
    HVAC_HOLD_MODE
  }_HVAC_OUTPUT_STATUS_FLAGS_;
  
  #define HEAT_ON()             LED4_ClrVal()
  #define HEAT_OFF()            LED4_SetVal() 
                                
  #define THERMOSTAT_HEATING()  (gu8HVACStatus & (1<<HVAC_HEATING))
  
  #define VENT_ON()             LED2_ClrVal()
  #define VENT_OFF()            LED2_SetVal()

  #define THERMOSTAT_VENTING()  (gu8HVACStatus & (1<<HVAC_VENTING))
                                  
  #define FAN_SWITCH_ON         LED1_GetVal()  
  
  #define COOL_ON()             LED3_ClrVal()
  #define COOL_OFF()            LED3_SetVal()
  
  #define THERMOSTAT_COOLING()  (gu8HVACStatus & (1<<HVAC_COOLING))
  
  #define THERMOSTAT_HOLD()     (gu8HVACStatus & (1<<HVAC_HOLD_MODE))
  /**
   * \brief Max temperature allowed to Start the Cooling sequence. The TSTAT shouldn't go above this temperature if working correctly
   */
  #define MAX_COOLING_TEMPERATURE          28
  
  /**
   * \brief Minimum temperature allowed to Start the Heating sequence. The TSTAT shouldn't go below this temp if working OK
   */
  #define MIN_HEATING_TEMPERATURE          18
  
  #define CLEAR_HVAC_FLAGS()               gu8HVACStatus = 0
  
  
  #pragma CONST_SEG NON_VOLATILE_DATA
    extern const UINT8 CoolingSetPoints[DAYS_OF_WEEK];
    extern const UINT8 HeatingSetPoints[DAYS_OF_WEEK];
  #pragma CONST_SEG DEFAULT
  extern UINT8 gu8HVACStatus;
  extern UINT8 gu8HoldTemperature;
  
  void vfnTempControlInit(void);
  void vfnThermostat_InitGPIO(void);
  void vfnThermostatResetOutputs(void);
  UINT8 u8ThermostatTempControl(UINT8 Temperature, UINT8 DayOfWeek);
  void vfnThermostatRunHold(UINT8 HoldTemperature);
  
#endif