#ifndef __S08_FLASH__
  #define __S08_FLASH__
  
  #include "derivative.h"
  #include "FslTypes.h"
  
  
  #define FLASH_MASS_ERASE_CMD  0x41
  #define FLASH_ERASE_CMD       0x40
  #define FLASH_PROGRAM_CMD     0x20
  #define FLASH_BURST_CMD       0x25
  
  #ifndef BUS_CLOCK
    #define BUS_CLOCK    8300000
  #endif
  
  #define FLASH_OK             0
  #define FLASH_ERROR           0xFF
  
  #if BUS_CLOCK > 12800000
    #define FLASH_CLOCK (UINT8)((BUS_CLOCK/1600000) + 0x40)
  #else
    #define FLASH_CLOCK (UINT8)(BUS_CLOCK/200000)
  #endif
  
  /* Macros to call the function using the different features */
  #define Flash_Erase(Address) \
          Flash_Cmd((UINT16)Address, (UINT16)1, (UINT8*) 0, FLASH_ERASE_CMD)
  
  #define Flash_Program(Address, Data) \
          Flash_Cmd((UINT16)Address, (UINT16)1, (UINT8*)&Data, FLASH_PROGRAM_CMD)
  
  #define Flash_Burst(Address, Size, DataPtr) \
          Flash_Cmd((UINT16)Address, (UINT16)Size, (UINT8*)DataPtr, FLASH_BURST_CMD)
          
  #pragma CODE_SEG FLASH_ROUTINES
  UINT8 Flash_Cmd(UINT16 FlashAddress, UINT8 FlashDataCounter, UINT8* pFlashDataPtr, UINT8 FlashCommand);
  
  #pragma CODE_SEG DEFAULT
  void FlashInit(void);
  void CopyInRAM(void);
#endif