/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : Cpu.C
**     Project   : PE_LL64_Quick_Start
**     Processor : MC9S08LL64C_LQFP80
**     Component : MC9S08LL64_80
**     Version   : Component 01.006, Driver 01.35, CPU db: 3.00.023
**     Datasheet : MC9S08LL64RM Rev. 4 07/2009
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 11/30/2009, 5:48 PM
**     Abstract  :
**         This bean "MC9S08LL64_80" contains initialization of the
**         CPU and provides basic methods and events for CPU core
**         settings.
**     Settings  :
**
**     Contents  :
**         EnableInt  - void Cpu_EnableInt(void);
**         DisableInt - void Cpu_DisableInt(void);
**
**     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Cpu. */

#pragma MESSAGE DISABLE C4002 /* WARNING C4002: Result not used is ignored */

#include "LCD1.h"
#include "ADC1.h"
#include "LED1.h"
#include "LED2.h"
#include "LED3.h"
#include "LED4.h"
#include "TOD1.h"
#include "IRQ1.h"
#include "AS1.h"
#include "ACCEL_SLEEP_B.h"
#include "KBI1.h"
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Events.h"
#include "Cpu.h"

#pragma CODE_SEG DEFAULT

/* Global variables */
volatile byte CCR_reg;                 /* Current CCR register */

/*Definition of global shadow variables*/
byte Shadow_PTB;

#pragma CODE_SEG __NEAR_SEG NON_BANKED

/*
** ===================================================================
**     Method      :  Cpu_Interrupt (component MC9S08LL64_80)
**
**     Description :
**         The method services unhandled interrupt vectors.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
ISR(Cpu_Interrupt)
{
  asm(BGND);
}

#pragma CODE_SEG DEFAULT

/*
** ===================================================================
**     Method      :  Cpu_DisableInt (component MC9S08LL64_80)
**
**     Description :
**         Disables maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_DisableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_EnableInt (component MC9S08LL64_80)
**
**     Description :
**         Enables maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_EnableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  _EntryPoint (component MC9S08LL64_80)
**
**     Description :
**         Initializes the whole system like timing and so on. At the end 
**         of this function, the C startup is invoked to initialize stack,
**         memory areas and so on.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
extern void _Startup(void);            /* Forward declaration of external startup function declared in file Start12.c */

#pragma NO_FRAME
#pragma NO_EXIT
#pragma CODE_SEG __NEAR_SEG NON_BANKED
void _EntryPoint(void)
{
  /* ### MC9S08LL64_80 "Cpu" init code ... */
  /*  PE initialization code after reset */

  /* Common initialization of the write once registers */
  /* SOPT1: COPE=0,COPT=1,STOPE=1,??=0,??=0,??=0,BKGDPE=1,RSTPE=1 */
  setReg8(SOPT1, 0x63);                 
  /* SPMSC1: LVDF=0,LVDACK=0,LVDIE=0,LVDRE=1,LVDSE=1,LVDE=0,BGBDS=1,BGBE=0 */
  setReg8(SPMSC1, 0x1A);                
  /* SPMSC2: LPR=0,LPRS=0,LPWUI=0,??=0,PPDF=0,PPDACK=0,PPDE=1,PPDC=0 */
  setReg8(SPMSC2, 0x02);                
  /* SPMSC3: LVDV=0,LVWV=0,LVWIE=0 */
  clrReg8Bits(SPMSC3, 0x38);            
  /*  System clock initialization */
  if (*(unsigned char*)0xFFAF != 0xFF) { /* Test if the device trim value is stored on the specified address */
    ICSTRM = *(unsigned char*)0xFFAF;  /* Initialize ICSTRM register from a non volatile memory */
    ICSSC = (unsigned char)((*(unsigned char*)0xFFAE) & (unsigned char)0x01); /* Initialize ICSSC register from a non volatile memory */
  }
  /* ICSC1: CLKS=0,RDIV=0,IREFS=0,IRCLKEN=1,IREFSTEN=0 */
  setReg8(ICSC1, 0x02);                /* Initialization of the ICS control register 1 */ 
  /* ICSC2: BDIV=0,RANGE=0,HGO=0,LP=0,EREFS=1,ERCLKEN=1,EREFSTEN=1 */
  setReg8(ICSC2, 0x07);                /* Initialization of the ICS control register 2 */ 
  while(!ICSSC_OSCINIT) {              /* Wait until the initialization of the external crystal oscillator is completed */
  }
  /* ICSSC: DRST_DRS=0,DMX32=1 */
  clrSetReg8Bits(ICSSC, 0xC0, 0x20);   /* Initialization of the ICS status and control */ 
  while((ICSSC & 0xC0) != 0x00) {      /* Wait until the FLL switches to Low range DCO mode */
  }
  /*** End of PE initialization code after reset ***/
  __asm   jmp _Startup ;               /* Jump to C startup code */

}
#pragma CODE_SEG DEFAULT

/*
** ===================================================================
**     Method      :  PE_low_level_init (component MC9S08LL64_80)
**
**     Description :
**         Initializes beans and provides common register initialization. 
**         The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PE_low_level_init(void)
{
  /* SCGC1: VREF2=0,TPM2=0,TPM1=1,ADC=1,VREF1=0,IIC=0,SCI2=0,SCI1=1 */
  setReg8(SCGC1, 0x31);                 
  /* SCGC2: DBG=1,FLS=1,IRQ=1,KBI=1,ACMP=0,TOD=1,LCD=1,SPI=0 */
  setReg8(SCGC2, 0xF6);                 
  /* Common initialization of the CPU registers */
  /* PTCD: PTCD5=1,PTCD4=1,PTCD3=1,PTCD2=1,PTCD1=1 */
  setReg8Bits(PTCD, 0x3E);              
  /* PTCPE: PTCPE7=1,PTCPE5=0,PTCPE4=0,PTCPE3=0,PTCPE2=0 */
  clrSetReg8Bits(PTCPE, 0x3C, 0x80);    
  /* PTCDD: PTCDD7=0,PTCDD5=1,PTCDD4=1,PTCDD3=1,PTCDD2=1,PTCDD1=1,PTCDD0=0 */
  clrSetReg8Bits(PTCDD, 0x81, 0x3E);    
  /* PTBD: PTBD7=1,PTBD6=1,PTBD5=0,PTBD4=1 */
  clrSetReg8Bits(PTBD, 0x20, 0xD0);     
  /* PTBPE: PTBPE5=1 */
  setReg8Bits(PTBPE, 0x20);             
  /* PTBDD: PTBDD7=1,PTBDD6=1,PTBDD5=1,PTBDD4=1 */
  setReg8Bits(PTBDD, 0xF0);             
  /* PTAPE: PTAPE7=1,PTAPE4=1 */
  setReg8Bits(PTAPE, 0x90);             
  /* PTASE: PTASE7=0,PTASE6=0,PTASE5=0,PTASE4=0,PTASE3=0,PTASE2=0,PTASE1=0,PTASE0=0 */
  setReg8(PTASE, 0x00);                 
  /* PTBSE: PTBSE7=0,PTBSE6=0,PTBSE5=0,PTBSE4=0,PTBSE2=0,PTBSE1=0,PTBSE0=0 */
  clrReg8Bits(PTBSE, 0xF7);             
  /* PTCSE: PTCSE7=0,PTCSE6=0,PTCSE5=0,PTCSE4=0,PTCSE3=0,PTCSE2=0,PTCSE1=0,PTCSE0=0 */
  setReg8(PTCSE, 0x00);                 
  /* PTDSE: PTDSE7=0,PTDSE6=0,PTDSE5=0,PTDSE4=0,PTDSE3=0,PTDSE2=0,PTDSE1=0,PTDSE0=0 */
  setReg8(PTDSE, 0x00);                 
  /* PTESE: PTESE7=0,PTESE6=0,PTESE5=0,PTESE4=0,PTESE3=0,PTESE2=0,PTESE1=0,PTESE0=0 */
  setReg8(PTESE, 0x00);                 
  /* PTADS: PTADS7=1,PTADS6=1,PTADS5=1,PTADS4=1,PTADS3=1,PTADS2=1,PTADS1=1,PTADS0=1 */
  setReg8(PTADS, 0xFF);                 
  /* PTBDS: PTBDS7=0,PTBDS6=0,PTBDS5=0,PTBDS4=0,??=0,PTBDS2=1,PTBDS1=1,PTBDS0=1 */
  setReg8(PTBDS, 0x07);                 
  /* PTCDS: PTCDS7=1,PTCDS6=1,PTCDS5=1,PTCDS4=1,PTCDS3=0,PTCDS2=0,PTCDS1=1,PTCDS0=1 */
  setReg8(PTCDS, 0xF3);                 
  /* PTDDS: PTDDS7=1,PTDDS6=1,PTDDS5=1,PTDDS4=1,PTDDS3=1,PTDDS2=1,PTDDS1=1,PTDDS0=1 */
  setReg8(PTDDS, 0xFF);                 
  /* PTEDS: PTEDS7=1,PTEDS6=1,PTEDS5=1,PTEDS4=1,PTEDS3=1,PTEDS2=1,PTEDS1=1,PTEDS0=1 */
  setReg8(PTEDS, 0xFF);                 
  /* PTAD: PTAD5=1 */
  setReg8Bits(PTAD, 0x20);              
  /* PTADD: PTADD5=1 */
  setReg8Bits(PTADD, 0x20);             
  /* ### Shared modules init code ... */
  /* ### Init_LCD "LCD1" init code ... */
  LCD1_Init();
  /* ### Init_ADC "ADC1" init code ... */
  ADC1_Init();
  /* ### BitIO "LED1" init code ... */
  /* ### BitIO "LED2" init code ... */
  /* ### BitIO "LED3" init code ... */
  /* ### BitIO "LED4" init code ... */
  /* ### Init_TOD "TOD1" init code ... */
  TOD1_Init();
  /* ### Init_IRQ "IRQ1" init code ... */
  IRQ1_Init();
  /* ### Asynchro serial "AS1" init code ... */
  AS1_Init();
  /* ### BitIO "ACCEL_SLEEP_B" init code ... */
  Shadow_PTB &= (byte)~0x20;           /* Initialize pin shadow variable bit */
  /* ### Init_KBI "KBI1" init code ... */
  KBI1_Init();
  __EI();                              /* Enable interrupts */
}

/* Initialization of the CPU registers in FLASH */

/* NVPROT: FPS6=1,FPS5=1,FPS4=1,FPS3=1,FPS2=1,FPS1=1,FPS0=1,FPDIS=1 */
const unsigned char NVPROT_INIT @0x0000FFBD = 0xFF;

/* NVOPT: KEYEN=0,FNORED=1,??=1,??=1,??=1,??=1,SEC1=1,SEC0=0 */
const unsigned char NVOPT_INIT @0x0000FFBF = 0x7E;

/* END Cpu. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 3.07 [04.34]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
