/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : ACCEL_SLEEP_B.C
**     Project   : PE_LL64_Quick_Start
**     Processor : MC9S08LL64C_LQFP80
**     Component : BitIO
**     Version   : Component 02.075, Driver 03.21, CPU db: 3.00.023
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 11/30/2009, 5:48 PM
**     Abstract  :
**         This bean "BitIO" implements an one-bit input/output.
**         It uses one bit/pin of a port.
**         Methods of this bean are mostly implemented as a macros
**         (if supported by target language and compiler).
**     Settings  :
**         Used pin                    :
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       36            |  PTB5_MOSI_SCL
**             ----------------------------------------------------
**
**         Port name                   : PTB
**
**         Bit number (in port)        : 5
**         Bit mask of the port        : $0020
**
**         Initial direction           : Output (direction can be changed)
**         Safe mode                   : yes
**         Initial output value        : 0
**         Initial pull option         : up
**
**         Port data register          : PTBD      [$0002]
**         Port control register       : PTBDD     [$0003]
**
**         Optimization for            : speed
**     Contents  :
**         SetDir - void ACCEL_SLEEP_B_SetDir(bool Dir);
**         GetVal - bool ACCEL_SLEEP_B_GetVal(void);
**         PutVal - void ACCEL_SLEEP_B_PutVal(bool Val);
**         ClrVal - void ACCEL_SLEEP_B_ClrVal(void);
**         SetVal - void ACCEL_SLEEP_B_SetVal(void);
**
**     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE ACCEL_SLEEP_B. */

#include "ACCEL_SLEEP_B.h"
  /* Including shared modules, which are used in the whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Cpu.h"


/*
** ===================================================================
**     Method      :  ACCEL_SLEEP_B_GetVal (component BitIO)
**
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pin and returns it
**           b) direction = Output : returns the last written value
**     Parameters  : None
**     Returns     :
**         ---             - Input value. Possible values:
**                           FALSE - logical "0" (Low level)
**                           TRUE - logical "1" (High level)

** ===================================================================
*/
/*
bool ACCEL_SLEEP_B_GetVal(void)

**  This method is implemented as a macro. See ACCEL_SLEEP_B.h file.  **
*/

/*
** ===================================================================
**     Method      :  ACCEL_SLEEP_B_PutVal (component BitIO)
**
**     Description :
**         This method writes the new output value.
**           a) direction = Input  : sets the new output value;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes the value to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val             - Output value. Possible values:
**                           FALSE - logical "0" (Low level)
**                           TRUE - logical "1" (High level)
**     Returns     : Nothing
** ===================================================================
*/
void ACCEL_SLEEP_B_PutVal(bool Val)
{
  if (Val) {
    setReg8Bits(PTBD, 0x20);           /* PTBD5=0x01 */
    Shadow_PTB |= (byte)0x20;          /* Set-up shadow variable */
  } else { /* !Val */
    clrReg8Bits(PTBD, 0x20);           /* PTBD5=0x00 */
    Shadow_PTB &= (byte)~0x20;         /* Set-up shadow variable */
  } /* !Val */
}

/*
** ===================================================================
**     Method      :  ACCEL_SLEEP_B_ClrVal (component BitIO)
**
**     Description :
**         This method clears (sets to zero) the output value.
**           a) direction = Input  : sets the output value to "0";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "0" to the
**                                   appropriate pin
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void ACCEL_SLEEP_B_ClrVal(void)

**  This method is implemented as a macro. See ACCEL_SLEEP_B.h file.  **
*/

/*
** ===================================================================
**     Method      :  ACCEL_SLEEP_B_SetVal (component BitIO)
**
**     Description :
**         This method sets (sets to one) the output value.
**           a) direction = Input  : sets the output value to "1";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "1" to the
**                                   appropriate pin
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void ACCEL_SLEEP_B_SetVal(void)

**  This method is implemented as a macro. See ACCEL_SLEEP_B.h file.  **
*/

/*
** ===================================================================
**     Method      :  ACCEL_SLEEP_B_SetDir (component BitIO)
**
**     Description :
**         This method sets direction of the bean.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Dir        - Direction to set (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
**     Returns     : Nothing
** ===================================================================
*/
void ACCEL_SLEEP_B_SetDir(bool Dir)
{
  if (Dir) {
    setReg8(PTBD, (getReg8(PTBD) & (~0x20)) | (Shadow_PTB & 0x20)); /* PTBD5=Shadow_PTB[bit 5] */
    setReg8Bits(PTBDD, 0x20);          /* PTBDD5=0x01 */
  } else { /* !Dir */
    clrReg8Bits(PTBDD, 0x20);          /* PTBDD5=0x00 */
  } /* !Dir */
}


/* END ACCEL_SLEEP_B. */
/*
** ###################################################################
**
**     This file was created by Processor Expert 3.07 [04.34]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
