/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file pt60_tower.h
*
* @author a13984
*
* @version 0.0.1
*
* @date Aug 23, 2011
*
* @brief application entry point which performs application specific tasks. 
*
*******************************************************************************
*
* provide a demo for how to initialize the PT60, output messages via SCI, 
* flash operations, etc.
* NOTE:
*	printf call may occupy a lot of memory (around 1924 bytes), so please
*	consider your code size before using printf.
******************************************************************************/


#ifndef PT60_TOWER_H_
#define PT60_TOWER_H_

/******************************************************************************
* Includes
******************************************************************************/

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros
******************************************************************************/
#define PT60_2N40C 	1   // has chip errata for SCIs
#define PT60_4N40C  2	// has no chip errata for SCIs
#define MASKSET	PT60_4N40C 	// has no chip errata for SCIs
//#define MASKSET	PT60_2N40C 	// has chip errata for SCIs

/* define print system log */
/* #define PRINT_SYS_LOG */

/* define output bus clock */
//#define OUTPUT_BUSCLK

/* define what clock mode at startup 
 * if USE_FEE is not defined by commenting out the following line, 
 * then it will use FEI mode which is default mode 
 * after reset  
 */
#define USE_FEE		/* FEE clock mode */	

/* define external crystal frequency */
#define EXT_CLK_CRYST	8000	/* in KHz, PT60 tower board includes 8MHz crystal*/

/* define BUS clock in HZ */
#if	!defined(USE_FEE)
	#define  BUS_CLK_HZ		 8000000L
#else
	#define  BUS_CLK_HZ		16000000L
#endif

/* define UART baud rate */
#define BR_9600

/* define SCI port # to be used */
#define USE_SCI		3							/* SCI2 is used on PT60 tower board */

/* USER LED definitions */
/* LED maps 
 * code		   PT60
 * LED0 <----> PTG0
 * LED1 <----> PTG1
 * LED2 <----> PTG2
 * LED3 <----> PTG3
 *  
 */
#define LED0_Init()			PORT_PTGOE_PTGOE0 = 1
#define LED0_Toggle()		PORT_PTGD_PTGD0  ^= 1
#define LED0_On()		    PORT_PTGD_PTGD0   = 0
#define LED0_Off()		    PORT_PTGD_PTGD0   = 1

#define LED1_Init()			PORT_PTGOE_PTGOE1 = 1
#define LED1_Toggle()		PORT_PTGD_PTGD1 ^= 1
#define LED1_On()		    PORT_PTGD_PTGD1   = 0
#define LED1_Off()		    PORT_PTGD_PTGD1   = 1

#define LED2_Init()			PORT_PTGOE_PTGOE2 = 1
#define LED2_Toggle()		PORT_PTGD_PTGD2 ^= 1
#define LED2_On()		    PORT_PTGD_PTGD2   = 0
#define LED2_Off()		    PORT_PTGD_PTGD2   = 1

#define LED3_Init()			PORT_PTGOE_PTGOE3 = 1
#define LED3_Toggle()		PORT_PTGD_PTGD3 ^= 1
#define LED3_On()		    PORT_PTGD_PTGD3   = 0
#define LED3_Off()		    PORT_PTGD_PTGD3   = 1


#define LED0_Set()          PORT_PTGD_PTGD0 = 1
#define LED0_Clear()		PORT_PTGD_PTGD0 = 0


#define LED1_Set()          PORT_PTGD_PTGD1 = 1
#define LED1_Clear()		PORT_PTGD_PTGD1 = 0


#define LED2_Set()          PORT_PTGD_PTGD2 = 1
#define LED2_Clear()		PORT_PTGD_PTGD2 = 0


#define LED3_Set()          PORT_PTGD_PTGD3 = 1
#define LED3_Clear()		PORT_PTGD_PTGD3 = 0

/* User buttons: 
 * SW1 :  PTA4/BKGD/MS ( can not be configured )
 * SW2 :  PTD5/KBI1P5
 * SW3 :  PTD4/KBI1P4
 * 
 */

//#define Button2_Is_Pressed()	(PORT_PTDD_PTDD5)
//#define Button3_Is_Pressed()	(PORT_PTDD_PTDD4)
#define Button2_Is_Pressed()	(!PORT_PTDD_PTDD5)
#define Button3_Is_Pressed()	(!PORT_PTDD_PTDD4)

/******************************************************************************
* Types
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/
void Button_Init(void);

#endif /* PT60_TOWER_H_ */
