/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file mtim.c
*
* @author a13984
*
* @version 0.0.1
*
* @date Aug 10, 2011
*
* @brief application entry point which performs application specific tasks. 
*
*******************************************************************************
*
* provide a demo for how to initialize the PT60, output messages via SCI, 
* flash operations, etc.
* NOTE:
*	printf call may occupy a lot of memory (around 1924 bytes), so please
*	consider your code size before using printf.
******************************************************************************/
#include "common.h"
#include "mtim.h"

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Constants and macros
******************************************************************************/

/******************************************************************************
* Local types
******************************************************************************/

/******************************************************************************
* Local function prototypes
******************************************************************************/

/******************************************************************************
* Local variables
******************************************************************************/

/******************************************************************************
* Local functions
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/
void MTIM0_Init( void );
void MTIM1_Init( void );
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: MTIM0_Init
   *
   * @brief initialize MTIM0
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void MTIM0_Init( void )
{
	MTIM0_CLK_CLKS = 0x01;   // fixed clock
	MTIM0_CLK_PS = 0x00;     // prescale is 0
	MTIM0_MOD	= MTIM0_MOD_VALUE;		//2ms
	MTIM0_SC_TRST = 1;		// RST count
	MTIM0_SC_TOIE = 1;      // enable TOF interrupt
	MTIM0_SC_TSTP = 0;      // count active
}
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: MTIM1_Init
   *
   * @brief initialize MTIM1
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void MTIM1_Init( void )
{
	MTIM1_CLK_CLKS = 0x01;   // fixed clock
	MTIM1_CLK_PS = 0x00;     // prescale is 0
	MTIM1_MOD	= MTIM0_MOD_VALUE;		//2ms
	MTIM1_SC_TRST = 1;		// RST count
	MTIM1_SC_TOIE = 1;      // enable TOF interrupt
	MTIM1_SC_TSTP = 0;      // count active
}

