/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file ir.c
*
* @author B37531
*
* @version 0.0.1
*
* @date Aug 23, 2011
*
* @brief IRDA deriver,to implement IR communicate with ACMP 
*
******************************************************************************/
#include "common.h"
#include "Uart.h"
#include "ir.h"
#include "pt60_tower.h"
#include "printf.h"
#include "string.h"
#include "main.h"
/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Constants and macros
******************************************************************************/

/******************************************************************************
* Local types
******************************************************************************/

/******************************************************************************
* Local function prototypes
******************************************************************************/

/******************************************************************************
* Local variables
******************************************************************************/
static unsigned char m_ucIR_TxBuff[16];
static unsigned char m_ucIR_RxBuff[16];
/******************************************************************************
* Local functions
******************************************************************************/
void FTM0CH0_Init( void );
void ACMP_Init ( void );
void IR_Init( void );
/******************************************************************************
* Global functions
******************************************************************************/
void IR_test( void );
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: FTM0CH0_Init
   *
   * @brief initialize FTM0CH0, EPWM output mode,frequency is 38khz
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void FTM0CH0_Init( void )
{
	// Init FTM0 to PWM output,frequency is 38khz
	FTM0_MOD = FTM0_MOD_VALUE;
	FTM0_C0SC = 0x28;
	FTM0_C0V = FTM0_C0V_VALUE;
	FTM0_SC = 0x08; // bus clock divide by 2
}
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: ACMP_Init
   *
   * @brief initialize ACMP
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void ACMP_Init ( void )
{
	ACMP_C1_DACVAL = 36;
	ACMP_C1 |= ACMP_C1_DACEN_MASK | ACMP_C1_DACREF_MASK;    // enable DAC
	ACMP_C0_ACPSEL = 0x03;
	ACMP_C0_ACNSEL = 0x01;
	ACMP_C2_ACIPE = 0x02;            // enable ACMP1 connect to PIN
	ACMP_CS_ACE = 1;                 // enable ACMP
}
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: IR_Init
   *
   * @brief initialize IR, enable ACMP ,SCI0 , 38khz as carrier
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void IR_Init( void )
{
	unsigned char dummy;
	unsigned char i;
	// init SCI0
	Init_SCI0(BUS_CLK_HZ);
	
	// clear RDRF flag
	SCI0_S2_RXINV = 1;
	
	PORT_PTBOE_PTBOE1 = 1;
	
	// initialize FTM0CH1 as 38k PWM output
	FTM0CH0_Init();
	// enable ACMP
	ACMP_Init();
	SYS_SOPT2_RXDFE = 1;
	SCI0_S2_RXINV = 0;

	SYS_SOPT2_TXDME = 1;
	SYS_SOPT2_RXDCE = 0;
	
	for(i=0;i<16;i++)
	{
		m_ucIR_TxBuff[i] = i;
	}

}
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: IR_test
   *
   * @brief test IRDA communication
   *             send a byte,then check received data whether correct
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void IR_test( void )
{
	unsigned short uiCount;
	volatile unsigned char dummy;
	unsigned char ucResultFlag = 0;
	unsigned char i;
	
#if(IR_MODE == IR_MODE_RX)	
	while( (SCI0_S1 & SCI0_S1_RDRF_MASK) != SCI0_S1_RDRF_MASK );
	SCI0_S1 |= SCI0_S1_RDRF_MASK;
	dummy = SCI0_D;
	TERMIO_PutChar1(dummy);
	//printf("IR Receive data:0x%x\n",dummy);

#elif(IR_MODE == IR_MODE_TEST)
	
	for(i=0;i<16;i++)
	{
		m_ucIR_TxBuff[i] += i-1;
		m_ucIR_RxBuff[i] = 0;
	}
	// if have invalid data in receiving buff,clear flag and discard it 
	if( (SCI0_S1 & SCI0_S1_RDRF_MASK) == SCI0_S1_RDRF_MASK )
	{
		dummy = SCI0_S1;
		dummy = SCI0_D;
	}
	// ready for transmit a frame data and receive it from echo board and verify received data 
	for( i = 0;i<16;i++)
	{
		 TERMIO_PutChar1(m_ucIR_TxBuff[i]);
		 uiCount = 0xffff;
		 while( (( SCI0_S1 & SCI0_S1_RDRF_MASK) != SCI0_S1_RDRF_MASK)&&
				 ( --uiCount) );
		 
		 if( uiCount == 0 )
		 {
			 printf("IR test failed!\n");
			 ucResultFlag |= 0x01;
			 break;
		 }
		 else
		 {
			 dummy = SCI0_S1;
			 m_ucIR_RxBuff[i] = SCI0_D;
		 }
	}
	
	if( memcmp(&m_ucIR_TxBuff[0],&m_ucIR_RxBuff[0],16) )
	{
		ucResultFlag |= 0x02;
	}
	else
	{
		ucResultFlag = 0;
	}
	
	if( ucResultFlag == 0 )
	{
		 printf("IR test success!\n");
		 LED3_Toggle();
		 LED2_Off();
		 LED1_Off();
		 LED0_Off();
	}
	else if( ucResultFlag == 2 )
	{
		 printf("x");
		 LED1_Toggle();
		 LED2_Off();
		 LED0_Off();
		 LED3_Off();
		 // @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		 // received data is wrong,need to add at last a byte time to synchronous receiving
		 DelayUS(4000); 
	}
	else
	{
		 LED1_Toggle();
		 LED2_Off();
		 LED0_Off();
		 LED3_Off();
	}
#endif
}	


