/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file iic.h
*
* @author a13984
*
* @version 0.0.1
*
* @date Sep 19, 2011
*
* @brief application entry point which performs application specific tasks. 
*
*******************************************************************************
*
* provide a demo for how to initialize the PT60, output messages via SCI, 
* flash operations, etc.
* NOTE:
*	printf call may occupy a lot of memory (around 1924 bytes), so please
*	consider your code size before using printf.
******************************************************************************/
#ifndef IIC_H_
#define IIC_H_

#include "mc9s08pt60.h"

typedef unsigned char uint8_t;
typedef	unsigned short uint16_t;

//#define MMA8451_I2C_ADDRESS    0x1D   // SA0 = 1
#define MMA8451_I2C_ADDRESS    0x1C   // SA0 = 0

#define i2c_DisableAck()       I2C_C1 |= I2C_C1_TXAK_MASK

#define i2c_SendAck()          I2C_SMB |= I2C_SMB_FACK_MASK; \
	                           I2C_C1 &= ~I2C_C1_TXAK_MASK     

#define i2c_RepeatedStart()    I2C_C1 |= I2C_C1_RSTA_MASK;

#define i2c_Start()            I2C_C1 |= I2C_C1_TX_MASK;\
                               I2C_C1 |= I2C_C1_MST_MASK;\
                               while(!I2C_S_BUSY)       // wait until busy

#define i2c_Stop()             I2C_C1 &= ~I2C_C1_MST_MASK;\
                               I2C_C1 &= ~I2C_C1_TX_MASK;\
                               while(I2C_S_BUSY)        // wait until not busy

#define i2c_EnterRxMode()      I2C_C1 &= ~I2C_C1_TX_MASK;\
                               I2C_C1 &= ~I2C_C1_TXAK_MASK

#define i2c_Wait()             while((I2C_S & I2C_S_IICIF_MASK)==0); \
                               I2C_S |= I2C_S_IICIF_MASK

#define i2c_write_byte(data)   I2C_D = data

#define MWSR                   0x00  /* Master write  */
#define MRSW                   0x01  /* Master read   */

void init_I2C(void);
void IIC_StartTransmission (unsigned char SlaveID, unsigned char Mode);
void MMA8451WriteRegister(unsigned char u8RegisterAddress, unsigned char u8Data);
unsigned int u8MMA8451ReadRegister(unsigned char u8RegisterAddress);
void MMA8451_Read_3axis_data(void);
void MMA8451_Initial (void);

#endif /* IIC_H_ */
