// Define for Clock Selection on CLOCKOUT
typedef enum {
 CLKOUT_OFF     =0x0,
 OSCOUT1_CLK 	=0x1,
 OSCOUT2_CLK 	=0x2,
 INTOSC_CLK  	=0x3,
 BUS_CLK	=0x4,
 CORE_CLK    	=0x5,
 LPO_CLK        =0x6,
 ADC0_ASYNC_CLK =0x8,
 ADC1_ASYNC_CLK =0x9
} SIM_CLKOUT_CLK_T;

typedef enum {
 CLKOUT_PTD5     =0x0,
 CLKOUT_PTA6	 =0x1
} SIM_CLKOUT_PAD_T;

typedef enum {
 DBG_PTE4     =0x0,
 DBG_PTE5     =0x1,
 DBG_PTE6     =0x2,
 DBG_PTE7     =0x3,
} DBG_OUT_PAD_T;


// Define location of debug signal on GPIO mux
#define DBGOUT0_AT_PTE4 1
#define DBGOUT1_AT_PTE5 1
#define DBGOUT2_AT_PTE6 1
#define DBGOUT3_AT_PTE7 1

// Define for debug mux selection
#define core_reset_seq_ff_AT_DBGOUT0    0
#define core_wait_AT_DBGOUT0 	     1
#define ext_force_bgnd_AT_DBGOUT0 	     2
#define core_stop_AT_DBGOUT0 	     3
#define core_bdc_exec_ff_AT_DBGOUT0     4
#define core_kill_write_t4_AT_DBGOUT0   5
#define pdb_triga_0_AT_DBGOUT0 	     7
#define pdb_pretrig_a_0_AT_DBGOUT0      8
#define adc_cocoa_0_AT_DBGOUT0          10

#define core_irq_t4_AT_DBGOUT1 	     1
#define ext_tag_AT_DBGOUT1 	     2
#define core_clk_en_AT_DBGOUT1          3
#define core_bdm_enable_AT_DBGOUT1      4
#define or_all_async_int_AT_DBGOUT1     5
#define mtim_tof_pulse_mtim1_AT_DBGOUT1 6
#define pdb_triga_1_AT_DBGOUT1 	     7
#define pdb_pretrig_a_1_AT_DBGOUT1      8
#define adc_cocoa_1_AT_DBGOUT1          10


#define core_bus_bdc_cycle_AT_DBGOUT2   1
#define ext_secure_en_AT_DBGOUT2        2
#define ipg_doze_AT_DBGOUT2 	     3
#define core_bgnd_AT_DBGOUT2 	     4
#define core_force_exec_ff_AT_DBGOUT2   5
#define mtim_tof_pulse_mtim2_AT_DBGOUT2 6
#define pdb_triga_0_AT_DBGOUT2 	     7
#define pdb_pretrig_b_0_AT_DBGOUT2      8
#define pmc_stop_AT_DBGOUT2             9
#define adc_cocob_0__AT_DBGOUT2         10

#define core_paged_access_AT_DBGOUT3 	1
#define core_sec_violation_ff_AT_DBGOUT3 	2
#define ics_safe_for_lprun_mode_AT_DBGOUT3 3
#define core_bgnd_exit_AT_DBGOUT3 		4
#define core_tag_exec_ff_AT_DBGOUT3 	5
#define mtim_tof_pulse_mtim3_AT_DBGOUT3 	6
#define pdb_triga_1_AT_DBGOUT3 		7
#define pdb_pretrig_b_1_AT_DBGOUT3 	8
#define pmc_stop_wakeup_AT_DBGOUT3 	9
#define adc_cocob_1_AT_DBGOUT3 		10

// defines for debug mux control register
#define DBGMUX10 (*(vuint8_t*)(0x1866)) // DBGMUX1[3:0],DBGMUX0[3:0]
#define DBGMUX32 (*(vuint8_t*)(0x1867)) // DBGMUX3[3:0],DBGMUX2[3:0]


/**********STARTFUNC**************************************************
 * Name:  SIM_CLKOUT
 * Purpose: Bringing a particular clock on CLKOUT for observability
 * Algorithm: 
 * Inputs:	clk : Clock which has to be observed
 * 		pad : selects the pad on which the CLKOUT will come
 * Outputs: NONE 
 * Return value: NONE
 * Assumptions : NONE
 * Child Functions : NONE
 *
 ***********ENDFUNC***************************************************/
void SIM_CLKOUT(SIM_CLKOUT_CLK_T clk,SIM_CLKOUT_PAD_T pad) ;

/**********STARTFUNC**************************************************
 * Name:  DBG_SIG_OUT
 * Purpose: Bringing a particular debug signal out on a particular GPIO
 * Algorithm: 
 * Inputs:	dbg_sig : select the DBG signal
 * 		pad     : selects the pad on which the DBG signal will come
 * Outputs: NONE 
 * Return value: NONE
 * Assumptions : NONE
 * Child Functions : NONE
 *
 ***********ENDFUNC***************************************************/
void DBG_SIG_OUT(int dbg_sig,DBG_OUT_PAD_T pad) ;


