/* ###################################################################
**     Filename    : main.c
**     Processor   : S32K14x
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.00
** @brief
**         Main module.
**         This module contains user's application code.
*/
/*!
**  @addtogroup main_module main module documentation
**  @{
*/
/* MODULE main */


/* Including necessary module. Cpu.h contains other modules needed for compiling.*/
#include "Cpu.h"



  volatile int exit_code = 0;

/* User includes (#include below this line is not maintained by Processor Expert) */
#include "serialbuf.h"
#include "task.h"
#include "usr7s4.h"
#include "string.h"
#include "cJSON.h"
#include "GPS_NEO_6M.h"
#include "debug.h"
#include "MMA845x.h"
#include "PCA85063A_RTC.h"


#define PEX_RTOS_START vTaskStartScheduler



#define DOMAIN "39.108.1.173"


static uint8_t sw4,sw5;

void app2(void* parm){
	char* data=pvPortMalloc(256);
	int len;
	int fd=*((int*)parm);
	int led;
	cJSON* root;
	while(1){
		len=socket_read(fd,data,256);
		data[len]=0;
		root=cJSON_Parse(data);
		if(root==NULL)
			continue;
		led=cJSON_GetObjectItem(root,"led")->valueint;
		if(led==1){
			PINS_DRV_TogglePins(PTE,(1<<21));
		}else if(led==2){
			PINS_DRV_TogglePins(PTE,(1<<22));
		}else if(led==3){
			PINS_DRV_TogglePins(PTE,(1<<23));
		}
		cJSON_Delete(root);
	}
}
void app1(){

	cJSON *root;
	uint32_t ts;
	float x,y,z;
	uint16_t adcRawValue;
	float adcValue;
	float longitude,latitude;

	ADC_DRV_ConfigConverter(INST_ADCONV1, &adConv1_ConvConfig0);
	serial_init();
	gps_init();
	debug_init();
	usr7s4_init();
	MMA845x_Init();
	PCA85063A_RTC_Init();
	socket_t sd;
	sd.domain=pvPortMalloc(strlen(DOMAIN)+1);
	strcpy(sd.domain,DOMAIN);
	sd.client_num=0;
	sd.type=USR_TCP;
	sd.time=USR_CONN_LONG;
	sd.port=2317;
	int fd=socket(&sd);
    int err=connect(fd);
	xTaskCreate(app2,"app2",256,NULL,5,NULL);
	while(1){
		//socket_write(fd,"test",4);
		PCA85063A_RTC_Get_TS(&ts);
		MMA845x_Get_accelerator(&x,&y,&z);
		ADC_DRV_ConfigChan(INST_ADCONV1, 0U, &adConv1_ChnConfig0);
		ADC_DRV_WaitConvDone(INST_ADCONV1);
		ADC_DRV_GetChanResult(INST_ADCONV1, 0U, &adcRawValue);
		gps_get_ll(&longitude,&latitude);
		adcValue = ((float) adcRawValue / 255.0) * 5;

		root=cJSON_CreateObject();
		if(root==NULL)
			while(1);
		cJSON_AddItemToObject(root, "x", cJSON_CreateNumber(longitude));
		cJSON_AddItemToObject(root, "y", cJSON_CreateNumber(latitude));
		cJSON_AddItemToObject(root, "accel_x", cJSON_CreateNumber(x));
		cJSON_AddItemToObject(root, "accel_y", cJSON_CreateNumber(y));
		cJSON_AddItemToObject(root, "accel_z", cJSON_CreateNumber(z));
		cJSON_AddItemToObject(root, "rtc", cJSON_CreateNumber(ts));
		cJSON_AddItemToObject(root, "sw5", cJSON_CreateNumber(sw5));
		cJSON_AddItemToObject(root, "sw4", cJSON_CreateNumber(sw4));
		cJSON_AddItemToObject(root, "adc", cJSON_CreateNumber(adcValue));
		char* out=cJSON_PrintUnformatted(root);
		if(out==NULL)
			while(1);
		cJSON_Delete(root);
		socket_write(0,out,strlen(out));
		vPortFree(out);
		vTaskDelay(100);
	}
}
void button_isr(){
	PINS_DRV_ClearPortIntFlagCmd(PORTC);
	pins_channel_type_t val=PINS_DRV_ReadPins(PTC);
	if((val&(1<<12))==0){
		//fall edge
		sw4=0;
	}else{
		//rise edge
		sw4=1;
	}
	if((val&(1<<13))==0){
		//fall edge
		sw5=0;

	}else{
		//rise edge
		sw5=1;
	}


}
/*!
  \brief The main function for the project.
  \details The startup initialization sequence is the following:
 * - startup asm routine
 * - main()
*/
int main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  #ifdef PEX_RTOS_INIT
    PEX_RTOS_INIT();                   /* Initialization of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of Processor Expert internal initialization.                    ***/
    CLOCK_SYS_Init(g_clockManConfigsArr, CLOCK_MANAGER_CONFIG_CNT,
  				   g_clockManCallbacksArr, CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(0U, CLOCK_MANAGER_POLICY_AGREEMENT);

    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS, g_pin_mux_InitConfigArr);

    EDMA_DRV_Init(&dmaController1_State,&dmaController1_InitConfig0,edmaChnStateArray,\
    				edmaChnConfigArray,EDMA_CONFIGURED_CHANNELS_COUNT);


    I2C_MasterInit(&i2c1_instance,&i2c1_MasterConfig0);
    INT_SYS_SetPriority(LPI2C1_Master_IRQn, 2);

    INT_SYS_InstallHandler(PORTC_IRQn, button_isr, (isr_t *)0);
    INT_SYS_EnableIRQ(PORTC_IRQn);


    xTaskCreate(app1,"app1",512,NULL,1,NULL);

  /* Write your code here */
  /* For example: for(;;) { } */

  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;) {
    if(exit_code != 0) {
      break;
    }
  }
  return exit_code;
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.1 [05.21]
**     for the Freescale S32K series of microcontrollers.
**
** ###################################################################
*/
