/*
 * GPS_NEO_6M.h
 *
 *  Created on: Jul 2, 2018
 *      Author: nxa07657
 */

#ifndef GPS_NEO_6M_H_
#define GPS_NEO_6M_H_

#include "Cpu.h"



/*
 * struct for NMEA
 */
typedef struct
{
	uint8_t num;			/*satellite number*/
	uint8_t eledeg;		    /*elevation in degrees*/
	uint16_t azideg;		/*azimuth in degrees to true*/
	uint8_t sn;				/*SNR in dB*/
}nmea_slmsg;

/*
 * struct for UTC
 */
typedef struct
{
		uint16_t year;
		uint8_t month;
		uint8_t date;
		uint8_t hour;
		uint8_t min;
		uint8_t sec;
}nmea_utc_time;

/*
 * struct to store NMEA message
 */
typedef struct
{
		uint8_t svnum;				/*satellites in view*/
		nmea_slmsg slmsg[12];
		nmea_utc_time utc;			/*UTC*/
		uint32_t latitude;			/*latitude * 100000*/
		uint8_t nshemi;				/*North or South*/
		uint32_t longitude;			/*longitude * 100000*/
		uint8_t ewhemi;				/*East or West*/
		uint8_t gpssta;				/*GPS quality indicator*/
		uint8_t posslnum;			/*Number of satellites in view, 00 - 12*/
		uint8_t possl[12];
		uint8_t fixmode;			/*mode*/
		uint16_t pdop;				/*PDOP in meters*/
		uint16_t hdop;				/*HDOP in meters*/
		uint16_t vdop;				/*VDOP in meters*/
		int altitude;				/*antenna altitude above/below mean-sea-level * 10*/
		uint16_t speed;				/*speed * 1000*/
}nmea_msg;

//void GPSMSG_Analysis(nmea_msg *gpsx, uint8_t *buf);
//void Send_NMEA_MSG(nmea_msg *gpsx);
//
//void NMEA_GPRMC_Analysis(nmea_msg *gpsx,uint8_t *buf);
//void NMEA_GPGSV_Analysis(nmea_msg *gpsx,uint8_t *buf);
//void NMEA_GPGGA_Analysis(nmea_msg *gpsx,uint8_t *buf);
//void NMEA_GPGSA_Analysis(nmea_msg *gpsx,uint8_t *buf);
//void NMEA_GPVTG_Analysis(nmea_msg *gpsx,uint8_t *buf);
//
//void Send_NMEA_GPRMC(nmea_msg *gpsx);
//void Send_NMEA_GPGSV(nmea_msg *gpsx);
//void Send_NMEA_GPGGA(nmea_msg *gpsx);
//void Send_NMEA_GPGSA(nmea_msg *gpsx);
//void Send_NMEA_GPVTG(nmea_msg *gpsx);

status_t gps_init();
void gps_get_ll(float *logitude,float *latitude);


#endif /* GPS_NEO_6M_H_ */
