/*
 * PCA85063A_RTC.h
 *
 *  Created on: Jul 18, 2018
 *      Author: nxa07657
 */

#include "cpu.h"

#ifndef PCA85063A_RTC_H_
#define PCA85063A_RTC_H_

#define CTR1_ADDR 0x00
#define CTR2_ADDR 0x01

#define SECOND  0x04
#define MINUTES 0x05
#define HOUR    0x06
#define DAY     0x07
#define WEEKDAY 0x08
#define MONTH   0x09
#define YEAR    0x0A

#define SECOND_ALARM  0x0B
#define MINUTES_ALARM 0x0C
#define HOUR_ALARM    0x0D
#define DAY_ALARM     0x0E
#define WEEKDAY_ALARM 0x0F


#define SW_RESET_CONF  0x10
#define CIE_ENABLE     0x04
#define HOUR_Mode_12   0x02
#define CAP_SEL_12_5PF 0x01

#define CLK_OK_MASK			 0x80
#define Alarm_Disabled_MASK  0x80

#define RTC_I2C &i2c1_instance
#define RTC_I2C_IRQn LPI2C0_Master_IRQn

typedef struct{
	uint8_t Second;
	uint8_t Minute;
	uint8_t Hour;
	uint8_t Day;
	uint8_t Weekday;
	uint8_t Month;
	uint16_t Year;
}RTC_Calendar_t;

status_t PCA85063A_RTC_Init(void);
status_t PCA85063A_RTC_Set_Calendar(RTC_Calendar_t Calendar);
status_t PCA85063A_RTC_Get_Calendar(RTC_Calendar_t *Calendar);
status_t PCA85063A_RTC_Set_Calendar_Alarm(RTC_Calendar_t Calendar_Alarm);
status_t PCA85063A_RTC_Get_Calendar_Alarm(RTC_Calendar_t *Calendar_Alarm);
void RTC_Time_Print(RTC_Calendar_t *RTC_Time);
status_t PCA85063A_RTC_Test(void);

#endif /* PCA85063A_RTC_H_ */
