/* ###################################################################
**     Filename    : main.c
**     Processor   : S32K14x
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.00
** @brief
**         Main module.
**         This module contains user's application code.
*/
/*!
**  @addtogroup main_module main module documentation
**  @{
*/
/* MODULE main */


  volatile int exit_code = 0;

/* User includes (#include below this line is not maintained by Processor Expert) */

#include "S32K148_TBOX_BSP.h"
#include "S32K148_TBOX_BSP_test_Config.h"

void S32K148_TBOX_BSP_Init(void);
uint32_t LoopCnt = 0;
rtc_timedate_t Current_RTC;/*use to store the S32K148 internal RTC date and time*/


//START_FUNCTION_DECLARATION_RAMSECTION
//int main(void)
//END_FUNCTION_DECLARATION_RAMSECTION
/*!
  \brief The main function for the project.
  \details The startup initialization sequence is the following:
 * - startup asm routine
 * - main()
*/
int main(void)
{
  /* Write your local variable definition here */
	uint8_t Scanf_Command[20] = {0};

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  #ifdef PEX_RTOS_INIT
    PEX_RTOS_INIT();                   /* Initialization of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */
  /* For example: for(;;) { } */

    /* Write your code here */

    S32K148_TBOX_BSP_Init();

    printf("The S32K148 based T_BOX BSP test project is running!\n");

#ifdef Moudle_BLE_test
    	  if(STATUS_SUCCESS==BLE_HC08_Test())
    		  printf("the HC08 BLE module has been tested and passed\n") ;
    	  else
    		  printf("the HC08 BLE module has been tested but failed\n") ;
#endif


      while(1)
      {

    	  OSIF_TimeDelay(200);/*delay 200ms*/

    	  printf("the main loop has been run %d times\n\r", ++LoopCnt);

#ifdef ADC_test
    	  ADC_Test();
#endif /*end of ADC_test*/

#ifdef UART_test
    	  UART_BSP_Test();
#endif /*end of UART_test*/

#ifdef CAN_test
    	  CAN_BSP_Test();
#endif /*end of CAN_test*/

#ifdef PWM_HS_Timer_IC_Test
    	  PWM_HS_Timer_BSP_Test();
#endif

#ifdef LIN_test
    	  LIN_BSP_Test();
#endif

#ifdef PCA85063A_RTC_test   /*test the PCA85063 RTC chip*/
    	  PCA85063A_RTC_Test();
#endif

#ifdef Internal_RTC_test	/*test the S32K148 internal RTC */
	  RTC_DRV_GetCurrentTimeDate(RTCTIMER1,&Current_RTC);/*get current RTC second timer and convert to RTC date and time*/

	  /* print it */
	  printf("Current RTC time from S32K148 internal RTC--YYYY/MM/DD--HH:MM:SS is:\n");

	  printf("%d/%d/%d--%d:%d:%d\n\r", Current_RTC.year,\
			Current_RTC.month,\
			Current_RTC.day,\
			Current_RTC.hour,\
			Current_RTC.minutes,\
			Current_RTC.seconds);
#endif

#ifdef MMA845x_ACC_test
    	  MMA8452_Test();	/*test the MMA8452Q accelerator */
#endif

#ifdef Moudle_GPS_test
    	  GPS_NEO_6M_test();/*test the GPS module*/
#endif

      }
  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;) {
    if(exit_code != 0) {
      break;
    }
  }
  return exit_code;
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END main */


/***************************************************************************
 * the board modules and peripherals initialization
 **************************************************************************/
void S32K148_TBOX_BSP_Init(void)
{
	 /* Initialize and configure clocks
	   * 	-	see clock manager component for details
	   */
	  CLOCK_SYS_Init(g_clockManConfigsArr, CLOCK_MANAGER_CONFIG_CNT,
							g_clockManCallbacksArr, CLOCK_MANAGER_CALLBACK_CNT);
	  CLOCK_SYS_UpdateConfiguration(0U, CLOCK_MANAGER_POLICY_FORCIBLE);

	  /* Initialize pins
	  *	-	See PinSettings component for more info
	  */
	  PINS_DRV_Init(NUM_OF_CONFIGURED_PINS, g_pin_mux_InitConfigArr);

#ifdef ADC_test
	  ADC_BSP_Init();
#endif /*end of ADC_test*/

#ifndef UART_test
#ifdef UART_PRINTF_ENABLE

	  /*
	   * initialze the EDMA for LPUART RX/TX
	   */
	  EDMA_DRV_Init(&dmaController1_State, &dmaController1_InitConfig0, edmaChnStateArray, edmaChnConfigArray, EDMA_CONFIGURED_CHANNELS_COUNT);
	  UART_Init(CONSOLE_UART, UART_CONFIG);

	  INT_SYS_SetPriority(LPUART1_RxTx_IRQn, 2);
#endif /*end of UART_PRINTF_ENABLE*/
#endif /*end of UART_test*/

#ifdef UART_test
	  /*
	   * initialze the EDMA for LPUART RX/TX
	   */
	  EDMA_DRV_Init(&dmaController1_State, &dmaController1_InitConfig0, edmaChnStateArray, edmaChnConfigArray, EDMA_CONFIGURED_CHANNELS_COUNT);
	  UART_BSP_Init();
#endif

#ifdef Moudle_GPS_test
	  /*
	   * start the GPS receive
	   */
	  GPS_NEO_6M_Start_Receive();

#endif

#ifdef CAN_test
	  CAN_BSP_Init();
#endif

#ifdef LIN_test

	  LIN_BSP_Init();
#endif

	  /*
	   * configure UJA1132 SBC for CAN/LIN transceiver work
	   */
//	  LPSPI_DRV_MasterInit(LPSPICOM1,&lpspiCom1State,&lpspiCom1_MasterConfig0);/*initialize the LPSPI module firstly for SBC configuration */
//	  UJA113X_Init(0,&sbc_uja113x1_InitConfig0,&sbc_uja113x1State);/*initialize the SBC*/

	  TSS_ADC_PWM_HS_RGBLED_Timer_BSP_Init();

#if(PCA85063A_RTC_test||MMA845x_ACC_test)/*initialize the I2C interface for PCA85063A and MMA845x*/
	  I2C_MasterInit(&i2c1_instance,&i2c1_MasterConfig0);
#endif

#ifdef PCA85063A_RTC_test
	  PCA85063A_RTC_Init();/*initialize the external stand-alone RTC chip*/
#endif

#ifdef MMA845x_ACC_test
	  MMA845x_Init(); /*initialize the MMA8452*/
#endif


#ifdef Internal_RTC_test

#ifdef UES_EXT_RTC_CLK_IN
	  RTC_CLK_ENABLE();/*enable the external 32.768KHz clock*/
	  /*
	   * SDK RTM2.0 does not initialize the LPOCLK register(which is write once after POR/LVR) to
	   * select the RTC clock source as user configured in clock_manager component
	   * so it's a must to configure it to select the external 32.768KHz oscillator or its default to use SIRC(8MHz)
	   */
	  SIM->LPOCLKS |= SIM_LPOCLKS_RTCCLKSEL(SRC_RTC_CLK_IN);
#endif /*end of UES_EXT_RTC_CLK_IN*/
	  RTC_DRV_Init(RTCTIMER1, &rtcTimer1_Config0);			/*Initialize the RTC*/
	  RTC_DRV_SetTimeDate(RTCTIMER1, &rtcTimer1_StartTime0);/*set the date and time for RTC to start working*/
	  RTC_DRV_StartCounter(RTCTIMER1);  					/*start the RTC counter*/

#endif /*end of Internal_RTC_test*/

}

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.1 [05.21]
**     for the Freescale S32K series of microcontrollers.
**
** ###################################################################
*/
