/*
 * LIN_BSP_Test.c
 *
 *  Created on: Sep 28, 2018
 *      Author: nxa07657
 */
/*
 * include the BSP and test configuration header
 */
#include "S32K148_TBOX_BSP.h"
#include "S32K148_TBOX_BSP_test_Config.h"

#ifdef LIN_test

uint8_t LIN0_txBuff[] = "1234567890";/*10 bytes*/
uint8_t LIN1_txBuff[] = "0987654321";/*10 bytes*/

uint8_t LIN0_rxBuff[100];
uint8_t LIN1_rxBuff[100];


/*!
* @brief Callback function to get time interval in nano seconds
* @param[out] ns - number of nanoseconds passed since the last call of the function
* @return dummy value
*/
uint32_t lin1TimerGetTimeIntervalCallback0(uint32_t *ns)
{
	uint32_t Elapsed_CounterValue;

	Elapsed_CounterValue = TIMING_GetElapsed(&timing_pal2_instance,0);
	*ns = Elapsed_CounterValue *12.5;/*1 Tick = 12.5ns*/

	return 0UL;
}

uint32_t lin2TimerGetTimeIntervalCallback0(uint32_t *ns)
{
	uint32_t Elapsed_CounterValue;

	Elapsed_CounterValue = TIMING_GetElapsed(&timing_pal2_instance,0);
	*ns = Elapsed_CounterValue *12.5;/*1 Tick = 12.5ns*/

  return 0UL;
}

void timing_pal2_channel_callBack0(void * userData)
{
// 	 PINS_DRV_TogglePins(LED_GPIO_PORT, (1<<LED_RED));/*toggle LED_RED*/
	 LIN_DRV_TimeoutService(INST_LIN1);
	 LIN_DRV_TimeoutService(INST_LIN2);
}


 void LIN_BSP_Init(void)
 {
	LIN_DRV_Init(INST_LIN1, &lin1_InitConfig0, &lin1_State);
	LIN_DRV_Init(INST_LIN2, &lin2_InitConfig0, &lin2_State);

	/*
	* initialize a timer for LIN timer service at certain interrupt period
	*/
	TIMING_Init(&timing_pal2_instance, &timing_pal2_InitConfig);
	TIMING_StartChannel(&timing_pal2_instance,0,40000);/*interrupt @ period of 40000*12.5ns = 500us*/
 }

 void LIN_BSP_Test(void)
 {
 //		LIN_DRV_SetTimeoutCounter(INST_LIN2,14);/*set timeout as 14*500us = 7000us*/
 //		LIN_DRV_ReceiveFrameData(INST_LIN2,LIN1_rxBuff,8);/*receive 8 Bytes*/
 //
 //		LIN_DRV_MasterSendHeader(INST_LIN1,0x11);/*Transmit the LIN header*/
 //		LIN_DRV_SetTimeoutCounter(INST_LIN1,4);/*set timeout as 4*500us = 2000us*/
 //		while(STATUS_SUCCESS!=LIN_DRV_GetTransmitStatus(INST_LIN1,&bytesRemaining));/*wait for transmit complete*/
 //
 //		LIN_DRV_SendFrameDataBlocking(INST_LIN1,LIN0_txBuff,8, 0xFFF);/*send the data frame via LIN1*/
 //
 //		while(STATUS_SUCCESS!=LIN_DRV_GetReceiveStatus(INST_LIN2,&bytesRemaining));/*wait for LIN2 receive complete*/

	   LIN_DRV_SendFrameDataBlocking(INST_LIN1,LIN0_txBuff,8, 0xFFF);/*send the data frame via LIN1*/

	   LIN_DRV_SendFrameDataBlocking(INST_LIN2,LIN1_txBuff,8, 0xFFF);/*send the data frame via LIN2*/

 //
 //		LIN_DRV_ReceiveFrameData(INST_LIN1,LIN0_rxBuff,8);/*receive 8 Bytes*/
 //
 //		LIN_DRV_MasterSendHeader(INST_LIN2,0x11);/*Transmit the LIN header*/
 //		LIN_DRV_SetTimeoutCounter(INST_LIN2,4);/*set timeout as 4*500us = 2000us*/
 //		while(STATUS_SUCCESS!=LIN_DRV_GetTransmitStatus(INST_LIN2,&bytesRemaining));/*wait for transmit complete*/
 //
 //		LIN_DRV_SendFrameDataBlocking(INST_LIN2,LIN1_txBuff,8, 0xFFF);/*send the data frame via LIN2*/
 //
 //		while(STATUS_SUCCESS!=LIN_DRV_GetReceiveStatus(INST_LIN1,&bytesRemaining));/*wait LIN1 for receive complete*/
 }

#endif
