/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : sbc_uja113x1.c
**     Project     : S32K148_Based_T_BOX_BSP_TestPrj_SDK_RTM2_0
**     Processor   : S32K148_144
**     Component   : sbc_uja113x
**     Version     : Component SDK_S32K14x_12, Driver 01.00, CPU db: 3.00.000
**     Repository  : SDK_S32K14x_12
**     Compiler    : GNU C Compiler
**     Date/Time   : 2018-11-05, 13:27, # CodeGen: 92
**     Abstract    :
**
**
**     Copyright 1997 - 2015 Freescale Semiconductor, Inc.
**     Copyright 2016-2017 NXP
**     All Rights Reserved.
**     
**     THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
**     IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
**     OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
**     IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
**     INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**     SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**     HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**     STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**     IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
**     THE POSSIBILITY OF SUCH DAMAGE.
** ###################################################################*/
/*!
** @file sbc_uja113x1.c
** @version 01.00
** @brief
**
*/
/*!
**  @addtogroup sbc_uja113x1_module sbc_uja113x1 module documentation
**  @{
*/

/*!
 * @file "sbc_uja113x1.c
 *
 * @page misra_violations MISRA-C:2012 violations
 *
 * @section [global]
 * Violates MISRA 2012 Advisory Rule 8.7, External variable could be made static.
 * The external variables will be used in other source files, with the same initialized values.
 *
 * @section [global]
 * Violates MISRA 2012 Required Rule 10.3, Expression assigned to a narrower or
 * different essential type.
 * This is required by the conversion of a bit-field (uint8_t) of a register
 * into a enum type. Enum type is strictly defined as unsigned integer.
 *
 * @section [global]
 * Violates MISRA 2012 Advisory Rule 10.5, Impermissible cast; cannot cast from
 * 'essentially unsigned' type to 'essentially enum<i>'.
 * This is required by the conversion of a bit-field (uint8_t) of a register
 * into a enum type. Enum type is strictly defined as unsigned integer.
 */


/* MODULE sbc_uja113x1. */

#include "sbc_uja113x1.h"

/*! @brief State structure for SBC */
uja113x_drv_cfg_t sbc_uja113x1State =
{
    /* A 5 voltage model selected by default, the user can change it to a 3 voltage model. */
    .chipType = UJA1132HWFD5V4,
    .lpspiInstance = 1U,
    /* 5 000 ms by default. The user can change this value. */
    .timeout = 5000U
};

/*! User configuration of HVIO bank 0 (HVIO 1- 4) */
extern const uja113x_hvio_bank_cfg_t sbc_uja113x1_bank0Config0;
const uja113x_hvio_bank_cfg_t sbc_uja113x1_bank0Config0 =
{
    .hvioConfig = {
        { /* HVIO 1 configuration. */
            .ionShutdownCtrl = IONSC_NONE,
            .ionActivateCtrl = IONAC_DEACTIVATED,
            .ionConfCtrl = IONCC_OFF,
        },
        { /* HVIO 2 configuration. */
            .ionShutdownCtrl = IONSC_NONE,
            .ionActivateCtrl = IONAC_DEACTIVATED,
            .ionConfCtrl = IONCC_OFF,
        },
        { /* HVIO 3 configuration. */
            .ionShutdownCtrl = IONSC_NONE,
            .ionActivateCtrl = IONAC_DEACTIVATED,
            .ionConfCtrl = IONCC_OFF,
        },
        { /* HVIO 4 configuration. */
            .ionShutdownCtrl = IONSC_NONE,
            .ionActivateCtrl = IONAC_DEACTIVATED,
            .ionConfCtrl = IONCC_OFF,
        },
    },
    .bankWupThr = false,
    .bankWupIntMask =
        IO15REIE_DISABLE |
        IO15FEIE_DISABLE |
        IO26REIE_DISABLE |
        IO26FEIE_DISABLE |
        IO37REIE_DISABLE |
        IO37FEIE_DISABLE |
        IO48REIE_DISABLE |
        IO48FEIE_DISABLE,
    .bankFailIntMask =
        IO15OLIE_DISABLE |
        IO15SCIE_DISABLE |
        IO26OLIE_DISABLE |
        IO26SCIE_DISABLE |
        IO37OLIE_DISABLE |
        IO37SCIE_DISABLE |
        IO48OLIE_DISABLE |
        IO48SCIE_DISABLE,
    .bscdtBankShortCirc = {
        .io15ShortCircuitThrCtrl = IONSCTC_30_MA,
        .io26ShortCircuitThrCtrl = IONSCTC_30_MA,
        .io37ShortCircuitThrCtrl = IONSCTC_30_MA,
        .io48ShortCircuitThrCtrl = IONSCTC_30_MA,
    },
    .boldtBankOpenLoad = {
        .io15OpenLoadThrCtrl = IONOLTC_2_MA,
        .io26OpenLoadThrCtrl = IONOLTC_2_MA,
        .io37OpenLoadThrCtrl = IONOLTC_2_MA,
        .io48OpenLoadThrCtrl = IONOLTC_2_MA,
    },
};

/*! User configuration of timer 1 */
extern const uja113x_timsc_cfg_t sbc_uja113x1_timer1Config0;
const uja113x_timsc_cfg_t sbc_uja113x1_timer1Config0 =
{
    .nTimer = 0U,
    .timXPeriodCtrl = TXPC_4MS_PERIOD,
    .timXModeCtrl = TXMC_PWM,
    .timXDutyCycleCtrl = 0U,
};

/*! User configuration of timer 2 */
extern const uja113x_timsc_cfg_t sbc_uja113x1_timer2Config0;
const uja113x_timsc_cfg_t sbc_uja113x1_timer2Config0 =
{
    .nTimer = 1U,
    .timXPeriodCtrl = TXPC_4MS_PERIOD,
    .timXModeCtrl = TXMC_PWM,
    .timXDutyCycleCtrl = 0U,
};

/*! User configuration of timer 3 */
extern const uja113x_timsc_cfg_t sbc_uja113x1_timer3Config0;
const uja113x_timsc_cfg_t sbc_uja113x1_timer3Config0 =
{
    .nTimer = 2U,
    .timXPeriodCtrl = TXPC_4MS_PERIOD,
    .timXModeCtrl = TXMC_PWM,
    .timXDutyCycleCtrl = 0U,
};

/*! User configuration of timer 4 */
extern const uja113x_timsc_cfg_t sbc_uja113x1_timer4Config0;
const uja113x_timsc_cfg_t sbc_uja113x1_timer4Config0 =
{
    .nTimer = 3U,
    .timXPeriodCtrl = TXPC_4MS_PERIOD,
    .timXModeCtrl = TXMC_PWM,
    .timXDutyCycleCtrl = 0U,
};

/*! User configuration of lock control register */
extern const uja113x_lckc_cfg_t sbc_uja113x1_lckcConfig0;
const uja113x_lckc_cfg_t sbc_uja113x1_lckcConfig0 =
{
    .lock0 = false,
    .lock1 = false,
    .lock2 = false,
    .lock3 = false,
    .lock4 = false,
    .lock5 = false,
    .lock6 = false,
};
/*! @brief User configuration structure 0 */
const uja113x_init_cfg_t sbc_uja113x1_InitConfig0 =
{
    /* Primary control registers. */
    .wdcWatchdogCfg = {
        .wtdModeCtrl = WMC_TIMEOUT,
        .nomWtdPeriod = NWP_PERIOD_128,
    },
    .mcSbcMode = MC_STANDBY,
	   .fscCfg = {
        .enShutdownCtrl = ENSC_NONE,
        .enDriverCtrl = true,
        .enCtrl = ENC_LOW,
        .limpHomeCtrl = false,
        .resetCntCtrl = 1U,
    },
    .sysieMask =
        OTWIE_ENABLE |
        SPIFIE_ENABLE,
    .memory0 = 0U,
    .memory1 = 0U,
    .memory2 = 0U,
    .memory3 = 0U,

    .rcRegulatorCfg = {
        .v2ShutdownCtrl = V2SC_NONE,
        .v2Ctrl = V2C_OFF,
        .v1RstThrCtrl = V1RTC_90_NOMINAL_OUT,
    },
    .bmcBatMonitorCfg = {
        .bmSrcCtrl = false,
        .bmUndrVoltThr = 0U,
        .bmOverVoltThr = 0U,
        .bmOverVoltThrRel = 0U,
        .bmUndrVoltThrRel = 0U,
    },
    .smpscSmpsCfg = {
        .smpsOvertempCtrl = false,
        .smpsCtrl = SMPSC_ON_NSR,
        .smpsOutVolt = SMPSOC_50V,
    },
    .supieMask =
        SMPSSIE_DISABLE |
        BMOIE_DISABLE |
        BMUIE_DISABLE |
        VEXTOIE_DISABLE |
        VEXTUIE_DISABLE |
        V1UIE_DISABLE,
    .cancCanCfg = {
        .canFDCtrl = true,
        .canPartNetCtrl = false,
        .canShutdownCtrl = CSC_NONE,
        .canModeCtrl = CMC_TRANSCEIVER_ACTIVE,
    },
    .cpncCanPartNetCfg = {
        .canDataRate = CDR_DATA_RATE_500a,
        .id = 0U,
        .idMask = 0U,
        .ide = false,
        .partNetDataMask = false,
        .dataLenCode = DLC_0,
    },
    .dmCanDataMaskCfg = {
        .dm0 = 0U,
        .dm1 = 0U,
        .dm2 = 0U,
        .dm3 = 0U,
        .dm4 = 0U,
        .dm5 = 0U,
        .dm6 = 0U,
        .dm7 = 0U,
    },
    .linxLinCtrl = {
        .lin2SlopeCtrl = LSC2_SLOPE_ACTIVE,
        .lin2ModeCtrl = LMC2_TRANSCEIVER_ON,
        .lin1SlopeCtrl = LSC1_SLOPE_ACTIVE,
        .lin1ModeCtrl = LMC1_TRANSCEIVER_ON,
    },
    .tieMask =
        CBSIE_DISABLE |
        CFIE_DISABLE |
        CWIE_DISABLE |
        L1WIE_ENABLE |
        L2WIE_ENABLE,
    /* Bank 0 configuration (HVIO 1 - 4). */
    .hvioBank0Cfg = &sbc_uja113x1_bank0Config0,
    /* Timer configuration. */
    .timscTimer1Cfg = &sbc_uja113x1_timer1Config0,
    .timscTimer2Cfg = &sbc_uja113x1_timer2Config0,
    .timscTimer3Cfg = &sbc_uja113x1_timer3Config0,
    .timscTimer4Cfg = &sbc_uja113x1_timer4Config0,
    /* Lock control configuration. */
    .lckcLockRegCfg = &sbc_uja113x1_lckcConfig0,
};
/*! sbc_uja113x1 configuration structure */
/* END sbc_uja113x1. */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.1 [05.21]
**     for the Freescale S32K series of microcontrollers.
**
** ###################################################################
*/
