/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : ethernet1.c
**     Project     : s32k148_ethernet_tja1101
**     Processor   : S32K148_144
**     Component   : enet
**     Version     : Component SDK_S32K14x_12, Driver 01.00, CPU db: 3.00.000
**     Repository  : SDK_S32K14x_12
**     Compiler    : GNU C Compiler
**     Date/Time   : 2018-11-19, 14:48, # CodeGen: 1
**
**     Copyright 1997 - 2015 Freescale Semiconductor, Inc.
**     Copyright 2016-2017 NXP
**     All Rights Reserved.
**     
**     THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
**     IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
**     OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
**     IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
**     INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**     SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**     HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**     STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**     IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
**     THE POSSIBILITY OF SUCH DAMAGE.
** ###################################################################*/
/*!
** @file ethernet1.c
** @version 01.00
*/
/*!
**  @addtogroup ethernet1_module ethernet1 module documentation
**  @{
*/

#include "ethernet1.h"

/**
 * @page misra_violations MISRA-C:2012 violations
 *
 * @section [global]
 * Violates MISRA 2012 Advisory Rule 8.7, External variable could be made static.
 * The external variables will be used in other source files, with the same initialized values.
 */

/*! @brief Number of receive buffer descriptors for ring 0 */
#define ENET_RXBD_NUM0_0 (4U)
/*! @brief Number of transmit buffer descriptors for ring 0 */
#define ENET_TXBD_NUM0_0 (4U)

enet_state_t ethernet1_State;

/*! @brief The MAC address of the module */
uint8_t ethernet1_MacAddr[6] = {0x22, 0x33, 0x44, 0x55, 0x66, 0x77};

/*! @brief Module configuration structures */
const enet_config_t ethernet1_InitConfig0 =
{
    .interrupts = 0,
    .maxFrameLen = 1518U,
    .miiMode = ENET_RMII_MODE,
    .miiSpeed = ENET_MII_SPEED_100M,
    .miiDuplex = ENET_MII_FULL_DUPLEX,
    .rxAccelerConfig = (uint8_t)ENET_RX_ACCEL_REMOVE_PAD | (uint8_t)ENET_RX_ACCEL_ENABLE_IP_CHECK | (uint8_t)ENET_RX_ACCEL_ENABLE_PROTO_CHECK,
    .txAccelerConfig = (uint8_t)ENET_TX_ACCEL_INSERT_IP_CHECKSUM | (uint8_t)ENET_TX_ACCEL_INSERT_PROTO_CHECKSUM,
    .rxConfig = (uint32_t)ENET_RX_CONFIG_ENABLE_PAYLOAD_LEN_CHECK | (uint32_t)ENET_RX_CONFIG_STRIP_CRC_FIELD | (uint32_t)ENET_RX_CONFIG_REMOVE_PADDING,
    .txConfig = 0,
    .ringCount = ETHERNET1_NUM_RINGS0,
    .callback = NULL
};

/*! @brief Receive buffer descriptors for ring 0 */
ALIGNED(FEATURE_ENET_BUFFDESCR_ALIGNMENT) static enet_buffer_descriptor_t ethernet1_rxBuffDescrip0_0[ENET_RXBD_NUM0_0];
/*! @brief Transmit buffer descriptors for ring 0 */
ALIGNED(FEATURE_ENET_BUFFDESCR_ALIGNMENT) static enet_buffer_descriptor_t ethernet1_txBuffDescrip0_0[ENET_TXBD_NUM0_0];

/*! @brief Receive data buffers for ring 0 */
ALIGNED(FEATURE_ENET_BUFF_ALIGNMENT) static uint8_t ethernet1_rxDataBuff0_0[ENET_RXBD_NUM0_0 * ENET_BUFF_ALIGN(1518U)];

/*! @brief Buffer configuration structures */
const enet_buffer_config_t ethernet1_buffConfigArr0[] = {
    {
        ENET_RXBD_NUM0_0,
        ENET_TXBD_NUM0_0,
        &ethernet1_rxBuffDescrip0_0[0],
        &ethernet1_txBuffDescrip0_0[0],
        &ethernet1_rxDataBuff0_0[0]
    },
};
/* END ethernet1. */

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.1 [05.21]
**     for the Freescale S32K series of microcontrollers.
**
** ###################################################################
*/


