/**
Copyright (c) 2009 Freescale Semiconductor

\file       Ascii.h
\brief      Header file to use the Thermostat Keys
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __THERMOSTAT_KEYS__
  #define __THERMOSTAT_KEYS__
  
/*****************************************************************************************************
* Include files
*****************************************************************************************************/  
  #include "S08_Keyboard.h"
  #include "S08_IRQ.h"
  #include "FslTypes.h"

/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
  typedef enum
  {
    TIME_DATE_KEY_PRESSED,
    PROGRAM_KEY_PRESSED,
    RUN_HOLD_KEY_PRESSED,
    UP_KEY_PRESSED,
    DOWN_KEY_PRESSED,
  }_TSTAT_KEYS_ENUM_;
  
/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
  #define UP_PIN               KB_PIN3
  #define DOWN_PIN             KB_PIN2
  #define TIME_PIN             KB_PIN1
  #define PROGRAM_PIN          KB_PIN0
  #define RUN_HOLD_PIN         PTCD_PTCD7
  
  #define UP_KEY               KB_PIN3_EVENT || (!(KB_PORT & (1<<UP_PIN)))
  #define DOWN_KEY             KB_PIN2_EVENT || (!(KB_PORT & (1<<DOWN_PIN)))
  #define TIME_DATE_KEY        KB_PIN1_EVENT || (!(KB_PORT & (1<<TIME_PIN)))
  #define PROGRAM_KEY          KB_PIN0_EVENT || (!(KB_PORT & (1<<RUN_HOLD_PIN)))
  #define RUN_HOLD_KEY         IRQ_Occurred()

  #define UP_KEY_CLEAR         KB_PIN3_CLEAR_EVENT
  #define DOWN_KEY_CLEAR       KB_PIN2_CLEAR_EVENT
  #define TIME_DATE_KEY_CLEAR  KB_PIN1_CLEAR_EVENT
  #define PROGRAM_KEY_CLEAR    KB_PIN0_CLEAR_EVENT
  #define RUN_HOLD_KEY_CLEAR   IRQ_Clear_Event()
  
  #define AcknowledgeKBInterrupts()     KBISC_KBACK = 1;\
                                        IRQSC_IRQACK = 1;
                                        
  #define DisableKBInterrupts()         KBISC_KBIE = 0;\
                                        IRQSC_IRQIE= 0;
  
  #define EnableKBInterrupts()          KBISC_KBIE = 1;\
                                        IRQSC_IRQIE= 1;
  
  #define THERMOSTAT_KB_PRESSED()    (TIME_DATE_KEY || UP_KEY || DOWN_KEY || PROGRAM_KEY || RUN_HOLD_KEY \
                                     || (!(KB_PORT & (1<<UP_PIN)))\
                                     || (!(KB_PORT & (1<<DOWN_PIN)))\
                                     || (!(KB_PORT & (1<<TIME_PIN)))\
                                     || (!(KB_PORT & (1<<PROGRAM_PIN))))
                                     
  
  #define THERMOSTAT_CLEAR_KEYS()    TIME_DATE_KEY_CLEAR;\
                                     UP_KEY_CLEAR;\
                                     DOWN_KEY_CLEAR;\
                                     PROGRAM_KEY_CLEAR;\
                                     RUN_HOLD_KEY_CLEAR


/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
  void vfnThermostatKeys_Init(void); 
  UINT8 u8ThermostatGetKey(void);
  
#endif
