/****************************************************************************************************/
/****************************************************************************************************/
/**
Copyright (c) 2009 Freescale Semiconductor

\file       ThermostatInit.c
\brief      File with initialization routines for the clock and system options registers
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __THERMOSTAT_INIT__
  #define __THERMOSTAT_INIT__

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
  #include "FslTypes.h"
  #include "derivative.h"
  #include "Thermostat_Definitions.h"

/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
  #define OSC_OK      0
  #define OSC_ERROR   1
  
/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
  void vfnClock_Init(void);
  void vfnSystem_Init(void);
  UINT8 u8fnSwitchToFBELP (void);
  void vfnGoToLowPower(void);
  void vfnExitLowPower(void);
  
#endif