/****************************************************************************************************/
/****************************************************************************************************/
/**
Copyright (c) 2009 Freescale Semiconductor

\file       S08_TOD_Driver.c
\brief      Code to use the TOD module available in the S08LL family
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "S08_TOD_Driver.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
UINT8 gu8TOD_Status;

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief    Converts an ASCII value into its hexadecimal equivalent
* \author   
* \param    lu8TOD_ClockSource ClockSource (Crystal frequency or internal reference)
* \param    lu8DesiredInterrupts Desired interrupts (Second, QSecond, Match)
* \param    lu8MatchValue Value for the Match Counter
* \return   void
* \todo     
* Initialization Steps:
  1. Configure TOD Clock Source
  2. Configure proper TOD Prescaler
  3. Write the TOD Match Register (If needed)
   3.1 Enable Match Functionallity
  4. Enable desired interrupts (Quarter Second, Second, Match)
  5. Enable TOD Clock Output (If needed)
  6. Enable TOD Module
*/
void vfnTOD_Init(UINT8 lu8TOD_ClockSource, UINT8 lu8DesiredInterrupts, UINT8 lu8MatchValue)
{
  /* Disable the module interrupts before starting the configuration */
  TODSC = 0;
  /* Steps 1 & 2 */
  TODC = lu8TOD_ClockSource;
  /* Start Match Register */
  TODM = lu8MatchValue;
  /* Step 4 */
  TODSC = (lu8DesiredInterrupts | TODSC_QSECF_MASK | TODSC_SECF_MASK | TODSC_MTCHF_MASK);
  /* Step 6 */
  TODC_TODEN = 1;
}

/****************************************************************************************************/
/**
* \brief    Interrupt Service Routine for the TOD driver
* \author   
* \param    void
* \return   void
* \todo     
*/
__interrupt VectorNumber_Vtod void TOD_ISR(void)
{
  if (TODSC_QSECF)
  {
    
    gu8TOD_Status |= (1<<TOD_QSECONDS);
  }
  if (TODSC_SECF)
  {
    gu8TOD_Status |= (1<<TOD_SECONDS);
  }
  if (TODSC_MTCHF)
  {
    gu8TOD_Status |= (1<<TOD_MATCH);
  }
  TODSC |= TODSC_MTCHF_MASK | TODSC_SECF_MASK | TODSC_QSECF_MASK;
}