/**
Copyright (c) 2009 Freescale Semiconductor

\file       S08_Flash.h
\brief      Header file for the flash write/erase routines
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __S08_FLASH__
  #define __S08_FLASH__

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
  #include "derivative.h"
  #include "FslTypes.h"
  
/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
#define FLASH_MASS_ERASE_CMD  0x41
  #define FLASH_ERASE_CMD       0x40
  #define FLASH_PROGRAM_CMD     0x20
  #define FLASH_BURST_CMD       0x25
  
  #ifndef BUS_CLOCK
    #define BUS_CLOCK    8300000
  #endif
  
  #define FLASH_OK             0
  #define FLASH_ERROR           0xFF
  
  #if BUS_CLOCK > 12800000
    #define FLASH_CLOCK (UINT8)((BUS_CLOCK/1600000) + 0x40)
  #else
    #define FLASH_CLOCK (UINT8)(BUS_CLOCK/200000)
  #endif
  
  /* Macros to call the function using the different features */
  #define Flash_Erase(Address) \
          Flash_Cmd((UINT16)Address, (UINT16)1, (UINT8*) 0, FLASH_ERASE_CMD)
  
  #define Flash_Program(Address, Data) \
          Flash_Cmd((UINT16)Address, (UINT16)1, (UINT8*)&Data, FLASH_PROGRAM_CMD)
  
  #define Flash_Burst(Address, Size, DataPtr) \
          Flash_Cmd((UINT16)Address, (UINT16)Size, (UINT8*)DataPtr, FLASH_BURST_CMD)

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
  #pragma CODE_SEG FLASH_ROUTINES
  UINT8 Flash_Cmd(UINT16 FlashAddress, UINT8 FlashDataCounter, UINT8* pFlashDataPtr, UINT8 FlashCommand);
  
  #pragma CODE_SEG DEFAULT
  void FlashInit(void);
  void CopyInRAM(void);
#endif