/****************************************************************************************************/
/****************************************************************************************************/
/**
Copyright (c) 2009 Freescale Semiconductor

\file       S08_ADC12.c
\brief      Hardware Abstraction Layer for the 12-bit ADC Module
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "S08_ADC12.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
#pragma DATA_SEG DEFAULT
UINT16* pADC_Pointer;
#pragma DATA_SEG MY_ZEROPAGE
static UINT8 near gu8ADCindex;
static volatile near UINT8 ADC_Chan_Table[] = {ADC1_CHAN};
#pragma DATA_SEG DEFAULT

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/


/************************************************************************************************/
/*                                      Functions Section                                       */
/************************************************************************************************/
#pragma CODE_SEG DEFAULT

/****************************************************************************************************/
/**
* \brief    Init the ADC waiting for a Hardware Trigger
* \author   
* \param    UINT8 u8ASCIIData - 
* \return   void
* \todo     
*/
void HWTrig_ADC_Init(UINT16* pADC_BufferPointer)
{
  gu8ADCindex = 0;
  SCGC1_ADC = 1;
  ADCSC1 = ADCSC1_AIEN_MASK;
  ADCSC2 = ADCSC2_ADTRG_MASK;
  ADCCFG = ADCCFG_ADIV1_MASK | ADCCFG_ADIV0_MASK | ADCCFG_MODE0_MASK | ADCCFG_ADICLK1_MASK| ADCCFG_ADICLK0_MASK;
  APCTL1 = APCTL1_REG;
  #ifdef APCTL2
    APCTL2 = APCTL2_REG;
  #endif
  
  #ifdef APCTL3
    APCTL3 = APCTL3_REG;
  #endif

  ADCSC1_ADCH = ADC_Chan_Table[gu8ADCindex];
  
  pADC_Pointer = pADC_BufferPointer;
}                           

/****************************************************************************************************/
/**
* \brief    Init the ADC module without HW Trigger
* \author   
* \param    UINT8 u8ASCIIData - 
* \return   void
* \todo     
*/
void ADC_Init(UINT16* pADC_BufferPointer)
{
  SCGC1_ADC = 1;
  ADCSC1 = 0;
  ADCSC2 = 0;
  ADCCFG = ADCCFG_ADLSMP_MASK | ADCCFG_ADIV1_MASK | ADCCFG_ADIV0_MASK | ADCCFG_MODE0_MASK | ADCCFG_ADICLK0_MASK;
  APCTL1 = APCTL1_REG; 
  #ifdef APCTL2
    APCTL2 = APCTL2_REG;
  #endif
  
  #ifdef APCTL3
    APCTL3 = APCTL3_REG;
  #endif
  
  pADC_Pointer = pADC_BufferPointer;
}                           


/****************************************************************************************************/
/**
* \brief    Start an ADC conversion in the specified channel
* \author   
* \param    UINT8 Chan
* \return   void
* \todo     
*/
void ADC_Start_conversion(UINT8 chan)
{
  ADCSC2 = 0; 
  ADCSC1 = ADCSC1_AIEN_MASK | chan;
  
}
  
/****************************************************************************************************/
/**
* \brief    Start Continous conversions in the ADC module
* \author   
* \param    void
* \return   void
* \todo     
*/
void ADC_Start_conversions(void)
{
	ADCSC1 = ADCSC1_ADCO_MASK;
}

/****************************************************************************************************/
/**
* \brief    Wait until the current conversion is finished and return the conversion value
* \author   
* \param    void
* \return   ADCR ADC Result
* \todo     
*/
UINT16 ADC_Get_Conversion(void)
{
  while(ADCSC2_ADACT)
  {
    //_Wait;
  }
  return ADCR;
}

/****************************************************************************************************/
/**
* \brief    Turns off the Peripheral Clock Gating for the ADC Module. Use only when the ADC won't be used in the project
* \author   
* \param    void
* \return   void
* \todo     
*/
void ADC_End(void)
{
  SCGC1_ADC = 0;
}

/****************************************************************************************************/
/**
* \brief    ADC Interrupt Service Routine. Stores the ADC result
* \author   
* \param    void
* \return   void
* \todo     
*/
void interrupt VectorNumber_Vadc ADC_ISR(void)
{
  *pADC_Pointer = ADCR;
  pADC_Pointer++;
  if(gu8ADCindex==(TOTAL_ADCs-1))
  {
    gu8ADCindex = 0;
    ADCSC2_ADTRG = 1;
    ADCSC1_ADCH = ADC_Chan_Table[gu8ADCindex];
    pADC_Pointer -= TOTAL_ADCs;
  }
  else
  {
    gu8ADCindex++;
    ADCSC2_ADTRG = 0;
    ADCSC1_ADCH = ADC_Chan_Table[gu8ADCindex];
 }
}