/****************************************************************************************************/
/**
Copyright (c) 2009 Freescale Semiconductor

\file       Cymbet.c
\brief      File intended to add the Cymbet Backup solution to the Thermostat (Not implemented yet)
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

#ifndef __CYMBET_H__

  #define __CYMBET_H__
  
  #include "FslTypes.h"
  #include "derivative.h"
  #include "S08_TPM.h"
  
  #define CONFIG_CBC_EVAL_EN_PULL_UP     PTBPE_PTBPE3 = 1
  #define CONFIG_CBC_EVAL_EN_DDR         PTBDD_PTBDD3 = 0
  
  //#define CONFIG_CBC_EVAL_RST()          IRQSC = IRQSC_IRQPE_MASK | IRQSC_IRQACK_MASK | IRQSC_IRQIE_MASK | IRQSC_IRQMOD_MASK
                                           /* TIMER_INIT (Timer, Configuration) */
  #define CONFIG_CBC_EVAL_RST()            TIMER_INIT(1, TPM_BUS_CLOCK | TPM_PRESCALER_1);\
  TIMER_CHANNEL_INIT(1, 0, (UINT8)(INPUT_CAPTURE_FALLING_EDGE | TPM_CHANNEL_INTERRUPT));
  
  #define CBC_RST_INTERRUPT()            gu8TPM_Status & (1<<TPM1_CHAN0_INTERRUPT) || (!PTCD_PTCD2)
  #define CBC_EVAL_ACK_INTERRUPT()       gu8TPM_Status &= ~(1<<TPM1_CHAN0_INTERRUPT)
  
  
  void vfnCymbet_Init(void);
  
  
#endif