/**
Copyright (c) 2009 Freescale Semiconductor

\file       Ascii.h
\brief      Header file for the ASCII handling routines
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __CALENDAR__
  #define __CALENDAR__
  /*****************************************************************************************************
  * Include files
  *****************************************************************************************************/  
  #include "Derivative.h"
  #include "FslTypes.h"
  #include "S08_TOD_Driver.h"
  /*****************************************************************************************************
  * Declaration of project wide TYPES
  *****************************************************************************************************/
  /** Real Time Clock Structure Definition */
  typedef struct
  {
    UINT8 Year;
    UINT8 Month;
    UINT8 Date;
    UINT8 Day;
    UINT8 Hours;
    UINT8 Minutes;
    UINT8 Seconds;
  }RTC_Type;
  
  /** Days of the Week (numbering) definition */
  typedef enum
  {
    _SUNDAY_,
    _MONDAY_,
    _TUESDAY_,
    _WEDNESDAY_,
    _THURSDAY_,
    _FRIDAY_,
    _SATURDAY_
  }Days_Of_The_Week_Enum;
  /*****************************************************************************************************
  * Definition of project wide VARIABLES
  *****************************************************************************************************/
  extern const UINT8 MonthsNames[12][3];
  extern const UINT8 DaysNames[7][2];
  extern RTC_Type Calendar_RTC;
  
  /*****************************************************************************************************
  * Definition of project wide MACROS / #DEFINE-CONSTANTS 
  *****************************************************************************************************/
  #define DAYS_OF_WEEK                   7
  #define MONTHS_PER_YEAR                12
  
  #define RESTART_CALENDAR_COUNTER()     TODC_TODR = 1
  
  #define CALENDAR_MATCH_EVENT           TOD_MATCH_EVENT
  #define CALENDAR_CLEAR_MATCH_EVENT     CLEAR_MATCH_EVENT
  
  #define CALENDAR_SECONDS_EVENT         TOD_SECONDS_EVENT
  #define CALENDAR_CLEAR_SECONDS_EVENT   CLEAR_SECONDS_EVENT
  
  #define DISABLE_CALENDAR_COUNTER()     TODC_TODEN = 0
  
  #define CALENDAR_ENABLE_QSEC_INT()     TODSC_QSECIE = 1
  #define CALENDAR_DISABLE_QSEC_INT()    TODSC_QSECIE = 0
  
  #define CALENDAR_ENABLE_SECONDS_INT()  TODSC_SECIE = 1
  #define CALENDAR_DISABLE_SECONDS_INT() TODSC_SECIE = 0
  
  #define CALENDAR_QSEC_EVENT            TOD_QSECONDS_EVENT
  #define CALENDAR_CLEAR_QSEC_EVENT      CLEAR_QSECONDS_EVENT
  
  #define CALENDAR_MATCH_WAKEUP_IN_5SECS       TOD_MATCH_5_SEC
  #define CALENDAR_MATCH_WAKEUP_IN_10SECS      TOD_MATCH_10_SEC
  #define CALENDAR_MATCH_WAKEUP_IN_15SECS      TOD_MATCH_15_SEC
  #define CALENDAR_MATCH_WAKEUP_IN_30SECS      TOD_MATCH_30_SEC
  #define CALENDAR_MATCH_WAKEUP_IN_60SECS      TOD_MATCH_60_SEC
  
  
  #define CALENDAR_WAKEUP_EVERY_QSEC     TODSC_QSECIE_MASK
  #define CALENDAR_WAKEUP_EVERY_1SEC     TODSC_SECIE_MASK
  #define CALENDAR_WAKEUP_ON_MATCH       (TODSC_MTCHIE_MASK | TODSC_MTCHEN_MASK)
  
  
  #define INIT_CALENDAR_COUNTER(WakeupOptions, WakeupTime)  \
  vfnTOD_Init(_TOD_32_768KHZ_XTAL_, WakeupOptions, WakeupTime)
 
  /*****************************************************************************************************
  * Declaration of project wide FUNCTIONS
  *****************************************************************************************************/
  void vfnCalendar_Init(UINT8 CalendarOptions, UINT8 CalendarWakeupPeriod);
  void vfnCalendar_UpdateDateAndTime(void);
  void vfnCalendar_SetTime (UINT8 Hours, UINT8 Minutes, UINT8 Seconds);
  void vfnCalendar_SetDate (UINT8 Year, UINT8 Month, UINT8 Date, UINT8 Day);
  
  void vfnCalendarUpdateHours(void);
  void vfnCalendarUpdateMinutes(void);
  void vfnCalendarUpdateDay(void);
  void vfnCalendarUpdateDate(void);
  void vfnCalendarUpdateMonth(void);
  void vfnCalendarUpdateYear(void);
  
#endif