/*******************************************************************************
*
* Copyright 2004-2016, Freescale Semiconductor, Inc.
* Copyright 2016-2019 NXP
* All rights reserved.
*
********************************************************************************
*
* FILE NAME: ftfe.h
*
* DESCRIPTION: Header file for the flash memory controller
*
*  FTFL_VERSION_1 .. 56F847xx devices, see MC56F847xxRM.pdf
*  FTFL_VERSION_2 .. 56F827xx devices, see MC56F827xxRM.pdf
*  FTFE_VERSION_3 .. 56F837xx devices, see MC56F837xxRM.pdf
*
*******************************************************************************/

#ifndef __FTFE_H
#define __FTFE_H

/* qs.h is a master header file, which must be included */

#if !defined(__ARCH_H) || !defined(__PERIPH_H) || !defined(__APPCONFIG_H)
#error Please include qs.h before ftfe.h
#endif

#ifdef __cplusplus
extern "C" {
#endif

/************************************************************
* FTFE module identifiers
*************************************************************/
#ifdef FTFE_BASE
#define FTFE (&ArchIO.Ftfe)
#endif

/*************************************************************
* arch.h should define device-specific information about FTFE
**************************************************************/

#if !defined(FTFE_VERSION)
#error FTFE not properly described in arch.h (old Quick_Start version?)
#endif

/* command names */

#define FTFE_INIT        /* NULL */


void ftfeInit(arch_sFTFE *pFtfeBase);
#define ioctlFTFE_INIT(pFtfeBase, param) ftfeInit(pFtfeBase)



#ifdef __cplusplus
}
#endif

#endif

