/*******************************************************************************
*
* Copyright 2004-2016, Freescale Semiconductor, Inc.
* Copyright 2016-2019 NXP
* All rights reserved.
*
********************************************************************************
*
* $File Name: ftfe.c$
*
* Description: Source file for the FTFE Driver
*
*****************************************************************************/

#include "qs.h"
#include "ftfe.h"

#ifdef __cplusplus
extern "C" {
#endif

void ftfeInit(arch_sFTFE *pFtfeBase)
{
#pragma unused(pFtfeBase)

    #ifdef FTFE_FSTAT_INIT
    periphMemWrite(FTFE_FSTAT_INIT, &pFtfeBase->fstat);
    #endif

    #ifdef FTFE_FCNFG_INIT
    periphMemWrite(FTFE_FCNFG_INIT, &pFtfeBase->fcnfg);
    #endif

    #ifdef FTFE_FSEC_INIT
    periphMemWrite(FTFE_FSEC_INIT, &pFtfeBase->fsec);
    #endif

    #ifdef FTFE_FOPT_INIT
    periphMemWrite(FTFE_FOPT_INIT, &pFtfeBase->fopt);
    #endif

    #ifdef FTFE_FCCOB3_INIT
    periphMemWrite(FTFE_FCCOB3_INIT, &pFtfeBase->fccob3);
    #endif

    #ifdef FTFE_FCCOB2_INIT
    periphMemWrite(FTFE_FCCOB2_INIT, &pFtfeBase->fccob2);
    #endif

    #ifdef FTFE_FCCOB1_INIT
    periphMemWrite(FTFE_FCCOB1_INIT, &pFtfeBase->fccob1);
    #endif

    #ifdef FTFE_FCCOB0_INIT
    periphMemWrite(FTFE_FCCOB0_INIT, &pFtfeBase->fccob0);
    #endif

    #ifdef FTFE_FCCOB7_INIT
    periphMemWrite(FTFE_FCCOB7_INIT, &pFtfeBase->fccob7);
    #endif

    #ifdef FTFE_FCCOB6_INIT
    periphMemWrite(FTFE_FCCOB6_INIT, &pFtfeBase->fccob6);
    #endif

    #ifdef FTFE_FCCOB5_INIT
    periphMemWrite(FTFE_FCCOB5_INIT, &pFtfeBase->fccob5);
    #endif

    #ifdef FTFE_FCCOBB_INIT
    periphMemWrite(FTFE_FCCOBB_INIT, &pFtfeBase->fccobb);
    #endif
    
    #ifdef FTFE_FCCOB4_INIT
    periphMemWrite(FTFE_FCCOB4_INIT, &pFtfeBase->fccob4);
    #endif

    #ifdef FTFE_FCCOBA_INIT
    periphMemWrite(FTFE_FCCOBA_INIT, &pFtfeBase->fccoba);
    #endif

    #ifdef FTFE_FCCOB9_INIT
    periphMemWrite(FTFE_FCCOB9_INIT, &pFtfeBase->fccob9);
    #endif

    #ifdef FTFE_FCCOB8_INIT
    periphMemWrite(FTFE_FCCOB8_INIT, &pFtfeBase->fccob8);
    #endif

    #ifdef FTFE_FPROT3_INIT
    periphMemWrite(FTFE_FPROT3_INIT, &pFtfeBase->fprot3);
    #endif

    #ifdef FTFE_FPROT2_INIT
    periphMemWrite(FTFE_FPROT2_INIT, &pFtfeBase->fprot2);
    #endif

    #ifdef FTFE_FPROT1_INIT
    periphMemWrite(FTFE_FPROT1_INIT, &pFtfeBase->fprot1);
    #endif

    #ifdef FTFE_FPROT0_INIT
    periphMemWrite(FTFE_FPROT0_INIT, &pFtfeBase->fprot0);
    #endif
    
#if FTFE_VERSION == 1  
    #ifdef FTFE_FEPROT_INIT
    periphMemWrite(FTFE_FEPROT_INIT, &pFtfeBase->feprot);
    #endif
    
    #ifdef FTFE_FDPROT_INIT
    periphMemWrite(FTFE_FDPROT_INIT, &pFtfeBase->fdprot);
    #endif
#endif
#if FTFE_VERSION == 3
    #ifdef FTFE_FERCNFG_INIT
    periphMemWrite(FTFE_FERCNFG_INIT, &pFtfeBase->fercnfg);
    #endif

#endif

}

#ifdef __cplusplus
}
#endif
