/**************************************************************************/
/* FILE NAME: m_uc3f.h                        COPYRIGHT (c) MOTOROLA 1999 */
/* VERSION:  0.3                                  All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION:                                                           */
/* This file defines all of the registers and bit fields on the UC3F      */
/* modules and declares an instance of the UC3F structure.                */
/*========================================================================*/
/* AUTHOR: Jeff Loeliger                                                  */
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/*                                                                        */
/* UPDATE HISTORY                                                         */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   J. Loeliger  13/Sep/99    Initial version of file for            */
/*                                   MPC565.                              */
/* 0.2   J. Loeliger   5/Oct/99    Update registers to match latest       */
/*                                   version of spec.                     */
/* 0.3   J. Loeliger  21/Jul/00    Changed names to match user's manual,  */
/*                                   including changing name to uc3f.     */
/**************************************************************************/
#ifndef _MPC565_UC3F_H
#define _MPC565_UC3F_H

#ifndef _MPC565_COMMON_H
#include "M_COMMON.h"
#endif /*  ifndef _MPC565_COMMON_H  */

#ifdef  __cplusplus
extern "C" {
#endif

/****************************************************************************/
/*                              MODULE : UC3F                               */
/****************************************************************************/
    struct UC3F_tag {           /*UC3F EEPROM Configuration Register */
        union {
            VUINT32 R;
            struct {
                VUINT32 STOP:1;
                VUINT32 LOCK:1;
                VUINT32 BPB:1;
                VUINT32 FIC:1;
                VUINT32 SIE:1;
                VUINT32 ACCESS:1;
                VUINT32 CENSOR:2;
                VUINT32 SUPV:8;
                VUINT32 DATA:8;
                VUINT32 PROTECT:8;
            } B;
        } UC3FMCR;

        union {                 /*UC3F EEPROM Extended Configuration Register */
            VUINT32 R;
            struct {
                VUINT32 SBEN:2;
                VUINT32 SBSUPV:2;
                VUINT32 SBDATA:2;
                VUINT32 SBPROTECT:2;
                VUINT32 WAIT:2;
                VUINT32 BIU:6;
                VUINT32 MEMSIZ:3;
                VUINT32 BLK:1;
                VUINT32 MAP:1;
                VUINT32 SBLKL:2;
                VUINT32 FLASHID:9;
            } B;
        } UC3FMCRE;

        union {                 /*UC3F EEPROM High Voltage Control Register */
            VUINT32 R;
            struct {
                VUINT32 HVS:1;
                VUINT32 PEGOOD:1;
                VUINT32 PEFI:1;
                VUINT32 EPEE:1;
                VUINT32 BOEM:1;
                  VUINT32:9;
                VUINT32 SBBLOCK:2;
                VUINT32 BLOCK:8;
                  VUINT32:1;
                VUINT32 CSC:1;
                  VUINT32:2;
                VUINT32 HSUS:1;
                VUINT32 PE:1;
                VUINT32 SES:1;
                VUINT32 EHV:1;
            } B;
        } UC3FCTL;
    };

/******************************************************************/
/* There are three way to create an instance of the CMF module:   */
/* -Use a fixed structure (Default)                               */
/* -Use the Diab compiler sections (if DIAB_SCETIONS is defined)  */
/* -Use a pointer (if HEADER_POINTERS is defined)                 */
/******************************************************************/
#ifdef DIAB_SECTIONS            /* Diab Compiler Only */

#pragma section UC3F_A  address=0x2FC800  /* Map modules to fixed addresses. */
#pragma use_section UC3F_A UC3F_A
    EXT struct UC3F_tag UC3F_A;

#pragma section UC3F_B  address=0x2FC840
#pragma use_section UC3F_B UC3F_B
    EXT struct UC3F_tag UC3F_B;

#else
#ifdef HEADER_POINTERS

/* Create a global pointer. */

#ifdef Main_Program
    struct UC3F_tag *UC3F_A = (struct UC3F_tag *) (INTERNAL_MEMORY_BASE + 0x2FC800);
    struct UC3F_tag *UC3F_B = (struct UC3F_tag *) (INTERNAL_MEMORY_BASE + 0x2FC840);
#else
    EXT struct C3F_tag *UC3F_A;
    EXT struct C3F_tag *UC3F_B;
#endif

#else

/* Use a fixed structure, this is the default */
#define UC3F_A  (*( struct UC3F_tag *)    (INTERNAL_MEMORY_BASE + 0x2FC800))
#define UC3F_B  (*( struct UC3F_tag *)    (INTERNAL_MEMORY_BASE + 0x2FC840))

#endif                          /* HEADER_POINTERS */

#endif                          /* DIAB_SECTIONS */

#ifdef  __cplusplus
}

#endif
#endif
/* ifndef _MPC565_UC3F_H  *//*****************************************************************************//* Motorola reserves the right to make changes without further notice to any *//* product herein to improve reliability, function, or design. Motorola does *//* not assume any  liability arising  out  of the  application or use of any *//* product,  circuit, or software described herein;  neither  does it convey *//* any license under its patent rights  nor the  rights of others.  Motorola *//* products are not designed, intended,  or authorized for use as components *//* in  systems  intended  for  surgical  implant  into  the  body, or  other *//* applications intended to support life, or  for any  other application  in *//* which the failure of the Motorola product  could create a situation where *//* personal injury or death may occur. Should Buyer purchase or use Motorola *//* products for any such intended  or unauthorized  application, Buyer shall *//* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, *//* affiliates,  and distributors harmless against all claims costs, damages, *//* and expenses, and reasonable  attorney  fees arising  out of, directly or *//* indirectly,  any claim of personal injury  or death  associated with such *//* unintended or unauthorized use, even if such claim alleges that  Motorola *//* was negligent regarding the  design  or manufacture of the part. Motorola *//* and the Motorola logo* are registered trademarks of Motorola Ltd.         *//*****************************************************************************/
