/**************************************************************************/
/* FILE NAME: m_toucan.h                      COPYRIGHT (c) MOTOROLA 1999 */
/* VERSION:  0.1                                  All Rights Reserved     */
/*                                                                        */
//* DESCRIPTION:                                                          */
/* This file defines all of the registers and bit fields on the TOUCAN    */
/* modules and declares an instance of the TOUCAN structure.              */
/*========================================================================*/
/* AUTHOR: Jeff Loeliger                                                  */
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/*                                                                        */
/* HISTORY                                                                */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   J. Loeliger  13/Sep/99    Initial version of file for            */
/*                                   Spanish Oak.                         */
/**************************************************************************/
#ifndef _SPOAK_TOUCAN_H
#define _SPOAK_TOUCAN_H

#ifndef _SPOAK_COMMON_H
#include "M_COMMON.h"
#endif /*  ifndef _SPOAK_COMMON_H  */

#ifdef  __cplusplus
extern "C" {
#endif

/****************************************************************************/
/*                              MODULE :TOUCAN                              */
/****************************************************************************/
    struct TOUCAN_tag {
        union {
            VUINT16 R;
            struct {
                VUINT16 STOP:1;
                VUINT16 FRZ:1;
                  VUINT16:1;
                VUINT16 HALT:1;
                VUINT16 NOTRDY:1;
                VUINT16 WAKEMSK:1;
                VUINT16 SOFTRST:1;
                VUINT16 FRZACK:1;
                VUINT16 SUPV:1;
                VUINT16 SELFWAKE:1;
                VUINT16 APS:1;
                VUINT16 STOPACK:1;
                  VUINT16:4;
            } B;
        } TCNMCR;

        union {
            VUINT16 R;
            VUINT16 B;
        } CANTCR;

        union {
            VUINT16 R;
            struct {
                VUINT16:5;
                VUINT16 IRL:3;
                VUINT16 ILBS:2;
                  VUINT16:6;
            } B;
        } CANICR;

        union {
            VUINT8 R;
            struct {
                VUINT8 BOFFMSK:1;
                VUINT8 ERRMSK:1;
                  VUINT8:2;
                VUINT8 RXMODE:2;
                VUINT8 TXMODE:2;
            } B;
        } CANCTRL0;

        union {
            VUINT8 R;
            struct {
                VUINT8 SAMP:1;
                  VUINT8:1;
                VUINT8 TSYNC:1;
                VUINT8 LBUF:1;
                  VUINT8:1;
                VUINT8 PROPSE:3;
            } B;
        } CANCTRL1;

        union {
            VUINT8 R;
            VUINT8 B;
        } PRESDIV;

        union {
            VUINT8 R;
            struct {
                VUINT8 RJW:2;
                VUINT8 PSEG:3;
                VUINT8 PSEG2:3;
            } B;
        } CANCTRL2;

        union {
            VUINT16 R;
            VUINT16 B;
        } TIMER;

        VUINT32 res43;

        union {
            VUINT16 R;
            struct {
                VUINT16 MID28:1;
                VUINT16 MID27:1;
                VUINT16 MID26:1;
                VUINT16 MID25:1;
                VUINT16 MID24:1;
                VUINT16 MID23:1;
                VUINT16 MID22:1;
                VUINT16 MID21:1;
                VUINT16 MID20:1;
                VUINT16 MID19:1;
                VUINT16 MID18:1;
                  VUINT16:2;
                VUINT16 MID17:1;
                VUINT16 MID16:1;
                VUINT16 MID15:1;
            } B;
        } RXGMSKHI;

        union {
            VUINT16 R;
            struct {
                VUINT16 MID14:1;
                VUINT16 MID13:1;
                VUINT16 MID12:1;
                VUINT16 MID11:1;
                VUINT16 MID10:1;
                VUINT16 MID9:1;
                VUINT16 MID8:1;
                VUINT16 MID7:1;
                VUINT16 MID6:1;
                VUINT16 MID5:1;
                VUINT16 MID4:1;
                VUINT16 MID3:1;
                VUINT16 MID2:1;
                VUINT16 MID1:1;
                VUINT16 MID0:1;
                  VUINT16:1;
            } B;
        } RXGMSKLO;

        union {
            VUINT16 R;
            struct {
                VUINT16 MID28:1;
                VUINT16 MID27:1;
                VUINT16 MID26:1;
                VUINT16 MID25:1;
                VUINT16 MID24:1;
                VUINT16 MID23:1;
                VUINT16 MID22:1;
                VUINT16 MID21:1;
                VUINT16 MID20:1;
                VUINT16 MID19:1;
                VUINT16 MID18:1;
                  VUINT16:2;
                VUINT16 MID17:1;
                VUINT16 MID16:1;
                VUINT16 MID15:1;
            } B;
        } RX14MSKHI;

        union {
            VUINT16 R;
            struct {
                VUINT16 MID14:1;
                VUINT16 MID13:1;
                VUINT16 MID12:1;
                VUINT16 MID11:1;
                VUINT16 MID10:1;
                VUINT16 MID9:1;
                VUINT16 MID8:1;
                VUINT16 MID7:1;
                VUINT16 MID6:1;
                VUINT16 MID5:1;
                VUINT16 MID4:1;
                VUINT16 MID3:1;
                VUINT16 MID2:1;
                VUINT16 MID1:1;
                VUINT16 MID0:1;
                  VUINT16:1;
            } B;
        } RX14MSKLO;

        union {
            VUINT16 R;
            struct {
                VUINT16 MID28:1;
                VUINT16 MID27:1;
                VUINT16 MID26:1;
                VUINT16 MID25:1;
                VUINT16 MID24:1;
                VUINT16 MID23:1;
                VUINT16 MID22:1;
                VUINT16 MID21:1;
                VUINT16 MID20:1;
                VUINT16 MID19:1;
                VUINT16 MID18:1;
                  VUINT16:2;
                VUINT16 MID17:1;
                VUINT16 MID16:1;
                VUINT16 MID15:1;
            } B;
        } RX15MSKHI;

        union {
            VUINT16 R;
            struct {
                VUINT16 MID14:1;
                VUINT16 MID13:1;
                VUINT16 MID12:1;
                VUINT16 MID11:1;
                VUINT16 MID10:1;
                VUINT16 MID9:1;
                VUINT16 MID8:1;
                VUINT16 MID7:1;
                VUINT16 MID6:1;
                VUINT16 MID5:1;
                VUINT16 MID4:1;
                VUINT16 MID3:1;
                VUINT16 MID2:1;
                VUINT16 MID1:1;
                VUINT16 MID0:1;
                  VUINT16:1;
            } B;
        } RX15MSKLO;

        VUINT32 res44;

        union {
            VUINT16 R;
            struct {
                VUINT16 BITER:2;
                VUINT16 ACKERR:1;
                VUINT16 CRCERR:1;
                VUINT16 FORMERR:1;
                VUINT16 STUFFERR:1;
                VUINT16 TXWARN:1;
                VUINT16 RXWARN:1;
                VUINT16 IDLE:1;
                VUINT16 TX_RX:1;
                VUINT16 FCS:2;
                  VUINT16:1;
                VUINT16 BOFFINT:1;
                VUINT16 ERRINT:1;
                VUINT16 WAKEINT:1;
            } B;
        } ESTAT;

        union {
            VUINT16 R;
            struct {
                VUINT16 IMASKH:8;
                VUINT16 IMASKL:8;
            } B;
        } IMASK;

        union {
            VUINT16 R;
            struct {
                VUINT16 IFLAGH:8;
                VUINT16 IFLAGL:8;
            } B;
        } IFLAG;
        union {
            VUINT8 R;
            VUINT8 B;
        } RXECTR;

        union {
            VUINT8 R;
            VUINT8 B;
        } TXECTR;

        VUINT32 res45[22];

        struct {
            union {
                VUINT16 R;
                struct {
                    VUINT16 TIMESTAMP:8;
                    VUINT16 CODE:4;
                    VUINT16 LENGTH:4;
                } B;
            } SCR;
            union {
                VUINT16 R;
                VUINT16 B;
            } ID_HIGH;
            union {
                VUINT16 R;
                VUINT16 B;
            } ID_LOW;
            union {
                VUINT8 R;
                VUINT8 B;
            } DATA[8];
            VUINT16 res45a;
        } MBUFF[16];

    };


/*******************************************************************/
/* There are three way to create an instance of the TOUCAN module: */
/* -Use a fixed structure (Default)                                */
/* -Use the Diab compiler sections (if DIAB_SCETIONS is defined)   */
/* -Use a pointer (if HEADER_POINTERS is defined)                  */
/*******************************************************************/
#ifdef DIAB_SECTIONS            /* Diab Compiler Only */

#pragma section CAN_A  address=0x307080  /* Map modules to fixed addresses. */
#pragma use_section CAN_A CAN_A
    EXT struct TOUCAN_tag CAN_A;

#pragma section CAN_B  address=0x307480
#pragma use_section CAN_B CAN_B
    EXT struct TOUCAN_tag CAN_B;

#pragma section CAN_C  address=0x307880
#pragma use_section CAN_C CAN_C
    EXT struct TOUCAN_tag CAN_C;

#else
#ifdef HEADER_POINTERS

/* Create a global pointer. */
#ifdef Main_Program
    struct TOUCAN_tag *CAN_A = (struct TOUCAN_tag *) (INTERNAL_MEMORY_BASE + 0x307080);
    struct TOUCAN_tag *CAN_B = (struct TOUCAN_tag *) (INTERNAL_MEMORY_BASE + 0x307480);
    struct TOUCAN_tag *CAN_C = (struct TOUCAN_tag *) (INTERNAL_MEMORY_BASE + 0x307880);
#else
    EXT struct TOUCAN_tag *CAN_A;
    EXT struct TOUCAN_tag *CAN_B;
    EXT struct TOUCAN_tag *CAN_C;
#endif

#else

/* Use a fixed structure, this is the default */
#define CAN_A  (*( struct TOUCAN_tag *) (INTERNAL_MEMORY_BASE + 0x307080))
#define CAN_B  (*( struct TOUCAN_tag *) (INTERNAL_MEMORY_BASE + 0x307480))
#define CAN_C  (*( struct TOUCAN_tag *) (INTERNAL_MEMORY_BASE + 0x307880))

#endif                          /* HEADER_POINTERS */

#endif                          /* DIAB_SECTIONS */

#ifdef  __cplusplus
}

#endif
#endif
/* ifndef _SPOAK_TOUCAN_H  *//*****************************************************************************//* Motorola reserves the right to make changes without further notice to any *//* product herein to improve reliability, function, or design. Motorola does *//* not assume any  liability arising  out  of the  application or use of any *//* product,  circuit, or software described herein;  neither  does it convey *//* any license under its patent rights  nor the  rights of others.  Motorola *//* products are not designed, intended,  or authorized for use as components *//* in  systems  intended  for  surgical  implant  into  the  body, or  other *//* applications intended to support life, or  for any  other application  in *//* which the failure of the Motorola product  could create a situation where *//* personal injury or death may occur. Should Buyer purchase or use Motorola *//* products for any such intended  or unauthorized  application, Buyer shall *//* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, *//* affiliates,  and distributors harmless against all claims costs, damages, *//* and expenses, and reasonable  attorney  fees arising  out of, directly or *//* indirectly,  any claim of personal injury  or death  associated with such *//* unintended or unauthorized use, even if such claim alleges that  Motorola *//* was negligent regarding the  design  or manufacture of the part. Motorola *//* and the Motorola logo* are registered trademarks of Motorola Ltd.         *//*****************************************************************************/
