/**************************************************************************/
/* FILE NAME: m_common.h                      COPYRIGHT (c) MOTOROLA 1999 */
/* VERSION:  0.1                                  All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION:                                                           */
/* This file defines all of the data types for the MPC500 family. It also */
/* defines compiler specific paramaters. This file is included by all     */
/* individual modules.                                                    */
/*========================================================================*/
/* AUTHOR: Jeff Loeliger                                                  */
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/*                                                                        */
/* UPDATE HISTORY                                                         */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   J. Loeliger  13/Sep/99    Initial version of file for            */
/*                                   MPC565.                              */
/**************************************************************************/
#ifndef _MPC565_COMMON_H
#define _MPC565_COMMON_H

/* If you wish to define DIAB_SECTIONS or HEADER_POINTERS within your code */
/*   uncomment one of the following lines or add the defines to your       */
/*   makefile like the exmaple programs, leave commented for default       */

 /* Diab Compiler Only */
/*#define DIAB_SECTIONS */

 /* Create a global pointer. */
/*#define HEADER_POINTERS */


typedef signed char INT8;
typedef unsigned char UINT8;
typedef volatile signed char VINT8;
typedef volatile unsigned char VUINT8;

typedef signed short INT16;
typedef unsigned short UINT16;
typedef volatile signed short VINT16;
typedef volatile unsigned short VUINT16;

typedef signed int INT32;
typedef unsigned int UINT32;
typedef volatile signed int VINT32;
typedef volatile unsigned int VUINT32;

typedef float FLOAT32;
typedef double FLOAT64;

/**************************************************************************/
/* INTERNAL_MEMORY_BASE must be assigned to one of the following values:  */
/*  0x00000000  0x00400000  0x00800000  0x00C00000                        */
/*  0x01000000  0x01400000  0x01800000  0x01C00000                        */
/* The INTERMAL_MEMERY_BASE can be defined on the command line by using   */
/* option -D INTERNAL_MEMORY_BASE 0x00400000. If it is not defined on the */
/* command line then it will use the value in this file.                  */
/**************************************************************************/

#ifndef INTERNAL_MEMORY_BASE
#define INTERNAL_MEMORY_BASE 0x00000000
#endif

#ifdef __DCC__                  /* only valid for Diab Compiler */
typedef signed long long INT64;
typedef unsigned long long UINT64;
typedef volatile signed long long VINT64;
typedef volatile unsigned long long VUINT64;

#define INTERRUPT __interrupt__

#else

/*****************************************************************/
/* The compiler specific modifier for interruput routines should */
/* be added here.                                                */
/*****************************************************************/
#define INTERRUPT

#endif /* ifdef __DCC__  */

/*******************************************************************/
/* This is only used if DIAB_SECTIONS or HEADER_POINTERS are used. */
/* Not extern if Called from main program, otherwise will get a    */
/* redeclaration warning during link.                              */
/*******************************************************************/
#undef EXT
#ifndef Main_Program
#define EXT extern
#else
#define EXT
#endif

#endif /* ifndef _MPC565_COMMON_H  */

/*****************************************************************************/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/
