/**************************************************************************/
/* FILE NAME: mpc555.h                        COPYRIGHT (c) MOTOROLA 1999 */
/* VERSION:  2.22                                 All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION:                                                           */
/* This file includes the files that contain all of the register and bit  */
/* field definitions for the MPC555.                                      */
/*                                                                        */
/*========================================================================*/
/* AUTHOR: Jeff Loeliger                                                  */
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/*                                                                        */
/* UPDATE HISTORY                                                         */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   J. Loeliger  06/Apr/98    Initial version of file.               */
/* 0.2a  J. Dunlop    22/Apr/98    Changed TBSCR/RTCSR/PISCR to 16-bit    */
/* 0.2b  G. Placido   25/May/98    Added bit level description            */
/* 0.3   J. Loeliger  22/Jun/98    Changed to standard typedefs           */
/*                                 Changed bit identifer to B             */
/*                                 Added ifdefs around typedefs and       */
/*                                      register information.             */
/*                                 Added #pragma section for Diab CC      */
/*                                      currently it does not work with   */
/*                                      the SDS debugger so a #ifdef      */
/*                                      does not compile it.              */
/*                                 Removed unneeded 'dummy' label from    */
/*                                      bit field defines.                */
/*                                 Made all register definitions unions.  */
/* 0.4   K. Muto      26/Jun/98    Change QSMCM buffer to 32              */
/*                                 Correct register names as Appendix A   */
/*                                      of MPC555 User's Manual           */
/* 0.5   J. Loeliger   6/Jul/98    Made TPU PARM use unions.              */
/*                                 Put #ifdef DIAB_SECTIONS around diab   */
/*                                      section directives.               */
/*                                 Tested all register names.             */
/* 1.0   J. Loeliger   7/Jul/98    Initial Release                        */
/* 1.01  J. Loeliger  26/Aug/98    Added missing bit 5 in MIOS1 PIO       */
/*                                      registers.                        */
/* 1.02  J. Loeliger   9/Sep/98    Fixed incorrect definition of TPUMCR3  */
/*                                      register from old User's Manual.  */
/* 1.03  J. Loeliger  24/Sep/98    Added second SRAM module. Changed      */
/*                                      DDRQST to DDRQS in QSMCM to match */
/*                                      new user's manual.                */
/* 1.04  J. Loeliger   4/Nov/98    Changed TBSCR, RTCSC & PISCR to 16 bit */
/*                                      registers. This was an error in   */
/*                                      early versions on the 555 manual. */
/* 1.05  J. Loeliger  10/Nov/98    Changed ENDQP & NEWQP in SPCR2 and     */
/*                                      CPTQP in SPSR to be 5 bits.       */
/* 1.06  J. Loeliger   5/Jan/99    Changed PDMCR to 32 bits and added     */
/*                                      bit fields.                       */
/* 1.10                7/Jan/99    Broke  header file into modules.       */
/* 2.00  J. Loeliger  19/Jan/99    Updated all files and added three ways */
/*                                      to create ans instance of the     */
/*                                      registers and added PACK.         */
/**************************************************************************/
#ifndef _MPC555_H
#define _MPC555_H

#include "m_usiu.h"
#include "m_flash.h"
#include "m_tpu3.h"
#include "m_qadc.h"
#include "m_qsmcm.h"
#include "m_mios1.h"
#include "m_toucan.h"
#include "m_uimb.h"
#include "m_sram.h"
#include "m_dptram.h"

#endif /* ifndef _MPC555_H */
