/**************************************************************************/
/* FILE NAME: m_usiu.h                        COPYRIGHT (c) MOTOROLA 2000 */
/* VERSION:  1.4                                  All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION:                                                           */
/* This file defines all of the registers and bit fields on the USIU      */
/* module and declares an instance of the USIU structure.                 */
/*========================================================================*/
/* AUTHOR: Jeff Loeliger                                                  */
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/*                                                                        */
/* HISTORY                                                                */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   J. Loeliger  06/Apr/98    Initial version of file.               */
/* 0.2                20/Dec/98    Broke  header file into modules.       */
/* 1.0   J. Loeliger  12/Jan/99    Added three ways to create an instance */
/*                                   of the module and added PACK.        */
/* 1.1   J. Loeliger  29/Mar/99    Added new WEBS field to BRx.           */
/* 1.2   J. Loeliger  22/Jun/99    Added ifdef to support C++             */
/*       K. Muto                   Added MTSC field to SIUMCR  and        */
/*                                 DBCT,DCSLR,MFPDL,LPML field to SCCR    */
/* 1.3   J. Loeliger  01/Sep/99    Changed RSRK to 32 bits and removed    */
/*                                   bit fields from key registers.       */
/* 1.4   J. Loeliger  04/Oct/00    Fixed location of COLIE bit. There is  */
/*                                   was incorrect in the user's manual.  */
/**************************************************************************/
#ifndef _MPC555_USIU_H
#define _MPC555_USIU_H

#ifndef _MPC555_COMMON_H
#include "M_COMMON.h"
#endif /*  ifndef _MPC555_COMMON_H  */

#ifdef  __cplusplus
extern "C" {
#endif

/****************************************************************************/
/*                              MODULE :USIU                                */
/****************************************************************************/
struct USIU_tag {
    union {
        VUINT32 R;
        struct {
            VUINT32 EARB:1;
            VUINT32 EARP:3;
              VUINT32:4;
            VUINT32 DSHW:1;
            VUINT32 DBGC:2;
            VUINT32 DBPC:1;
            VUINT32 ATWC:1;
            VUINT32 GPC:2;
            VUINT32 DLK:1;
              VUINT32:1;
            VUINT32 SC:2;
            VUINT32 RCTX:1;
            VUINT32 MLRC:2;
              VUINT32:2;
            VUINT32 MTSC:1;
              VUINT32:7;
        } B;
    } SIUMCR;

    union {
        VUINT32 R;
        struct {
            VUINT32 SWTC:16;
            VUINT32 BMT:8;
            VUINT32 BME:1;
              VUINT32:3;
            VUINT32 SWF:1;
            VUINT32 SWE:1;
            VUINT32 SWRI:1;
            VUINT32 SWP:1;
        } B;
    } SYPCR;

    VUINT32 res0;
    VUINT16 res1;

    union {
        VUINT16 R;
        struct {
            VUINT16 SWSR:16;
        } B;
    } SWSR;

    union {
        VUINT32 R;
        struct {
            VUINT32 IRQ0:1;
            VUINT32 LVL0:1;
            VUINT32 IRQ1:1;
            VUINT32 LVL1:1;
            VUINT32 IRQ2:1;
            VUINT32 LVL2:1;
            VUINT32 IRQ3:1;
            VUINT32 LVL3:1;
            VUINT32 IRQ4:1;
            VUINT32 LVL4:1;
            VUINT32 IRQ5:1;
            VUINT32 LVL5:1;
            VUINT32 IRQ6:1;
            VUINT32 LVL6:1;
            VUINT32 IRQ7:1;
            VUINT32 LVL7:1;
              VUINT32:16;
        } B;
    } SIPEND;

    union {
        VUINT32 R;
        struct {
            VUINT32 IRM0:1;
            VUINT32 LVM0:1;
            VUINT32 IRM1:1;
            VUINT32 LVM1:1;
            VUINT32 IRM2:1;
            VUINT32 LVM2:1;
            VUINT32 IRM3:1;
            VUINT32 LVM3:1;
            VUINT32 IRM4:1;
            VUINT32 LVM4:1;
            VUINT32 IRM5:1;
            VUINT32 LVM5:1;
            VUINT32 IRM6:1;
            VUINT32 LVM6:1;
            VUINT32 IRM7:1;
            VUINT32 LVM7:1;
              VUINT32:16;
        } B;
    } SIMASK;

    union {
        VUINT32 R;
        struct {
            VUINT32 ED0:1;
            VUINT32 WM0:1;
            VUINT32 ED1:1;
            VUINT32 WM1:1;
            VUINT32 ED2:1;
            VUINT32 WM2:1;
            VUINT32 ED3:1;
            VUINT32 WM3:1;
            VUINT32 ED4:1;
            VUINT32 WM4:1;
            VUINT32 ED5:1;
            VUINT32 WM5:1;
            VUINT32 ED6:1;
            VUINT32 WM6:1;
            VUINT32 ED7:1;
            VUINT32 WM7:1;
              VUINT32:16;
        } B;
    } SIEL;

    union {
        VUINT32 R;
        struct {
            VUINT32 INTERRUPT_CODE:8;
              VUINT32:24;
        } B;
    } SIVEC;

    union {
        VUINT32 R;
        struct {
            VUINT32:18;
            VUINT32 IEXT:1;
            VUINT32 IBMT:1;
              VUINT32:6;
            VUINT32 DEXT:1;
            VUINT32 DBM:1;
              VUINT32:4;
        } B;
    } TESR;

    union {
        VUINT32 R;
        VUINT32 B;
    } SGPIODT1;

    union {
        VUINT32 R;
        struct {
            VUINT32 SGPIOC:8;
            VUINT32 SGPIOA:24;
        } B;
    } SGPIODT2;

    union {
        VUINT32 R;
        struct {
            VUINT32 SDDRC:8;
              VUINT32:8;
            VUINT32 GDDR0:1;
            VUINT32 GDDR1:1;
            VUINT32 GDDR2:1;
            VUINT32 GDDR3:1;
            VUINT32 GDDR4:1;
            VUINT32 GDDR5:1;
              VUINT32:2;
            VUINT32 SDDRD:8;
        } B;
    } SGPIOCR;

    union {
        VUINT32 R;
        struct {
            VUINT32:16;
            VUINT32 PRPM:1;
            VUINT32 SLVM:1;
              VUINT32:1;
            VUINT32 SIZE:2;
            VUINT32 SUPU:1;
            VUINT32 INST:1;
              VUINT32:2;
            VUINT32 RESV:1;
            VUINT32 CONT:1;
              VUINT32:1;
            VUINT32 TRAC:1;
            VUINT32 SIZEN:1;
              VUINT32:2;
        } B;
    } EMCR;

    VUINT32 res1aa;
    VUINT32 res1ab;

    union {
        VUINT32 R;
        struct {
            VUINT32 SLRC0:1;
            VUINT32 SLRC1:1;
            VUINT32 SLRC2:1;
            VUINT32 SLRC3:1;
              VUINT32:2;
              VUINT32 PRDS:1;
              VUINT32 SPRDS:1;
              VUINT32:24;
        } B;
    } PDMCR;

    VUINT32 res2[48];

    /*Memory Controller Registers */
    union {
        VUINT32 R;
        struct {
            VUINT32 BA:17;
            VUINT32 AT:3;
            VUINT32 PS:2;
              VUINT32:1;
            VUINT32 WP:1;
              VUINT32:2;
            VUINT32 WEBS:1;
            VUINT32 TBDIP:1;
            VUINT32 LBDIP:1;
            VUINT32 SETA:1;
            VUINT32 BI:1;
            VUINT32 V:1;
        } B;
    } BR0;

    union {
        VUINT32 R;
        struct {
            VUINT32 AM:17;
            VUINT32 ATM:3;
            VUINT32 CSNT:1;
            VUINT32 ACS:2;
            VUINT32 EHTR:1;
            VUINT32 SCY:4;
            VUINT32 BSCY:3;
            VUINT32 TRLX:1;
        } B;
    } OR0;

    union {
        VUINT32 R;
        struct {
            VUINT32 BA:17;
            VUINT32 AT:3;
            VUINT32 PS:2;
              VUINT32:1;
            VUINT32 WP:1;
              VUINT32:2;
            VUINT32 WEBS:1;
            VUINT32 TBDIP:1;
            VUINT32 LBDIP:1;
            VUINT32 SETA:1;
            VUINT32 BI:1;
            VUINT32 V:1;
        } B;
    } BR1;

    union {
        VUINT32 R;
        struct {
            VUINT32 AM:17;
            VUINT32 ATM:3;
            VUINT32 CSNT:1;
            VUINT32 ACS:2;
            VUINT32 EHTR:1;
            VUINT32 SCY:4;
            VUINT32 BSCY:3;
            VUINT32 TRLX:1;
        } B;
    } OR1;

    union {
        VUINT32 R;
        struct {
            VUINT32 BA:17;
            VUINT32 AT:3;
            VUINT32 PS:2;
              VUINT32:1;
            VUINT32 WP:1;
              VUINT32:2;
            VUINT32 WEBS:1;
            VUINT32 TBDIP:1;
            VUINT32 LBDIP:1;
            VUINT32 SETA:1;
            VUINT32 BI:1;
            VUINT32 V:1;
        } B;
    } BR2;

    union {
        VUINT32 R;
        struct {
            VUINT32 AM:17;
            VUINT32 ATM:3;
            VUINT32 CSNT:1;
            VUINT32 ACS:2;
            VUINT32 EHTR:1;
            VUINT32 SCY:4;
            VUINT32 BSCY:3;
            VUINT32 TRLX:1;
        } B;
    } OR2;

    union {
        VUINT32 R;
        struct {
            VUINT32 BA:17;
            VUINT32 AT:3;
            VUINT32 PS:2;
              VUINT32:1;
            VUINT32 WP:1;
              VUINT32:2;
            VUINT32 WEBS:1;
            VUINT32 TBDIP:1;
            VUINT32 LBDIP:1;
            VUINT32 SETA:1;
            VUINT32 BI:1;
            VUINT32 V:1;
        } B;
    } BR3;

    union {
        VUINT32 R;
        struct {
            VUINT32 AM:17;
            VUINT32 ATM:3;
            VUINT32 CSNT:1;
            VUINT32 ACS:2;
            VUINT32 EHTR:1;
            VUINT32 SCY:4;
            VUINT32 BSCY:3;
            VUINT32 TRLX:1;
        } B;
    } OR3;

    VUINT32 res3[8];

    union {
        VUINT32 R;
        struct {
            VUINT32:1;
            VUINT32 BA:6;
              VUINT32:3;
            VUINT32 AT:3;
              VUINT32:15;
            VUINT32 DMCS:3;
            VUINT32 DME:1;
        } B;
    } DMBR;

    union {
        VUINT32 R;
        struct {
            VUINT32:1;
            VUINT32 AM:6;
              VUINT32:3;
            VUINT32 ATM:3;
              VUINT32:19;
        } B;
    } DMOR;

    VUINT32 res4[12];

    union {
        VUINT16 R;
        struct {
            VUINT16:8;
            VUINT16 WPER0:1;
            VUINT16 WPER1:1;
            VUINT16 WPER2:1;
            VUINT16 WPER3:1;
              VUINT16:4;
        } B;
    } MSTAT;

    VUINT16 res4a;
    VUINT32 res4b[33];

    /*System integration Timers */
    union {
        VUINT16 R;
        struct {
            VUINT16 TBIRQ:8;
            VUINT16 REFA:1;
            VUINT16 REFB:1;
              VUINT16:2;
            VUINT16 REFAE:1;
            VUINT16 REFBE:1;
            VUINT16 TBF:1;
            VUINT16 TBE:1;
        } B;
    } TBSCR;

    VUINT16 res4c;

    union {
        VUINT32 R;
        VUINT32 B;
    } TBREF0;

    union {
        VUINT32 R;
        VUINT32 B;
    } TBREF1;

    VUINT32 res5[5];

    union {
        VUINT16 R;
        struct {
            VUINT16 RTCIRQ:8;
            VUINT16 SEC:1;
            VUINT16 ALR:1;
              VUINT16:1;
            VUINT16 M:1;
            VUINT16 SIE:1;
            VUINT16 ALE:1;
            VUINT16 RTF:1;
            VUINT16 RTE:1;
        } B;
    } RTCSC;

    VUINT16 res5a;

    union {
        VUINT32 R;
        VUINT32 B;
    } RTC;

    union {
        VUINT32 R;
        VUINT32 B;
    } RTSEC;

    union {
        VUINT32 R;
        VUINT32 B;
    } RTCAL;

    VUINT32 res6[4];

    union {
        VUINT16 R;
        struct {
            VUINT16 PIRQ:8;
            VUINT16 PS:1;
              VUINT16:4;
            VUINT16 PIE:1;
            VUINT16 PITF:1;
            VUINT16 PTE:1;
        } B;
    } PISCR;

    VUINT16 res6a;

    union {
        VUINT32 R;
        struct {
            VUINT32 PITC:16;
              VUINT32:16;
        } B;
    } PITC;

    union {
        VUINT32 R;
        struct {
            VUINT32 PIT:16;
              VUINT32:16;
        } B;
    } PITR;

    VUINT32 res7[13];

    /*Clocks and Reset */
    union {
        VUINT32 R;
        struct {
            VUINT32 DBCT:1;
            VUINT32 COM:2;
            VUINT32 DCSLR:1;
            VUINT32 MFPDL:1;
            VUINT32 LPML:1;
            VUINT32 TBS:1;
            VUINT32 RTDIV:1;
            VUINT32 STBUC:1;
              VUINT32:1;
            VUINT32 PRQEN:1;
            VUINT32 RTSEL:1;
            VUINT32 BUCS:1;
            VUINT32 EBDF:2;
            VUINT32 LME:1;
            VUINT32 EECLK:2;
            VUINT32 ENGDIV:6;
              VUINT32:1;
            VUINT32 DFNL:3;
              VUINT32:1;
            VUINT32 DFNH:3;
        } B;
    } SCCR;

    union {
        VUINT32 R;
        struct {
            VUINT32 MF:12;
            VUINT32 MFPDL:1;
            VUINT32 LOCS:1;
            VUINT32 LOCSS:1;
            VUINT32 SPLS:1;
            VUINT32 SPLSS:1;
            VUINT32 TEXPS:1;
            VUINT32 LPML:1;
            VUINT32 TMIST:1;
              VUINT32:1;
            VUINT32 CSRC:1;
            VUINT32 LPM:2;
            VUINT32 CSR:1;
            VUINT32 LOLRE:1;
              VUINT32:1;
            VUINT32 DIVF:5;
        } B;
    } PLPRCR;

    union {
        VUINT16 R;
        struct {
            VUINT16 EHRS:1;
            VUINT16 ESRS:1;
            VUINT16 LLRS:1;
            VUINT16 SWRS:1;
            VUINT16 CSRS:1;
            VUINT16 DBHRS:1;
            VUINT16 DBSRS:1;
            VUINT16 JTRS:1;
            VUINT16 OCCS:1;
            VUINT16 ILBC:1;
            VUINT16 GPOR:1;
            VUINT16 GHRST:1;
            VUINT16 GSRST:1;
              VUINT16:3;
        } B;
    } RSR;

    VUINT16 res7a;

    union {
        VUINT16 R;
        struct {
            VUINT16 COLIRQ:8;
            VUINT16 COLIS:1;
              VUINT16:1;
            VUINT16 COLIE:1;
              VUINT16:5;
        } B;
    } COLIR;

    VUINT16 res7B;

    union {
        VUINT16 R;
        struct {
            VUINT16:1;
            VUINT16 LVSRS:4;
            VUINT16 VSRDE:1;
              VUINT16:10;
        } B;
    } VSRMCR;

    VUINT16 res7c;
    VUINT32 res8[27];

    /*System Inegration Timer Keys */
    union {
        VUINT32 R;
        VUINT32 B;
    } TBSCRK;

    union {
        VUINT32 R;
        VUINT32 B;
    } TBREF0K;

    union {
        VUINT32 R;
        VUINT32 B;
    } TBREF1K;

    union {
        VUINT32 R;
        VUINT32 B;
    } TBK;

    VUINT32 res9[4];

    union {
        VUINT32 R;
        VUINT32 B;
    } RTCSCK;

    union {
        VUINT32 R;
        VUINT32 B;
    } RTCK;

    union {
        VUINT32 R;
        VUINT32 B;
    } RTSECK;

    union {
        VUINT32 R;
        VUINT32 B;
    } RTCALK;

    VUINT32 res10[4];

    union {
        VUINT32 R;
        VUINT32 B;
    } PISCRK;

    union {
        VUINT32 R;
        VUINT32 B;
    } PITCK;

    VUINT32 res11[14];

    /*Clocks and Reset Keys */
    union {
        VUINT32 R;
        VUINT32 B;
    } SCCRK;

    union {
        VUINT32 R;
        VUINT32 B;
    } PLPRCRK;

    union {
        VUINT32 R;
        VUINT32 B;
    } RSRK;
};


/******************************************************************/
/* There are three way to create an instance of the USIU module:  */
/* -Use a fixed structure (Default)                               */
/* -Use the Diab compiler sections (if DIAB_SCETIONS is defined)  */
/* -Use a pointer (if HEADER_POINTERS is defined)                 */
/******************************************************************/
#ifdef DIAB_SECTIONS            /* Diab Compiler Only */

#pragma section USIU address=0x2FC000  /* Map modules to fixed addresses. */
#pragma use_section USIU USIU
EXT struct USIU_tag USIU;

#else
#ifdef HEADER_POINTERS

/* Create a global pointer. */
#ifdef Main_Program
struct USIU_tag *USIU = (struct USIU_tag *) (INTERNAL_MEMORY_BASE + 0x2FC000);
#else
EXT struct USIU_tag *USIU;
#endif

#else

/* Use a fixed structure, this is the default */
#define USIU  (*( struct USIU_tag *)  (INTERNAL_MEMORY_BASE + 0x2FC000))

#endif /* HEADER_POINTERS */

#endif /* DIAB_SECTIONS */

#ifdef  __cplusplus
}
#endif

#endif /* ifndef _MPC555_USIU_H  */

/*****************************************************************************/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/
