/**************************************************************************/
/* FILE NAME: m_flash.h                       COPYRIGHT (c) MOTOROLA 1999 */
/* VERSION:  1.2                                  All Rights Reserved     */
/*                                                                        */
//* DESCRIPTION:                                                          */
/* This file defines all of the registers and bit fields on the FLASH     */
/* modules and declares an instance of the FLASH structure.               */
/*========================================================================*/
/* AUTHOR: Jeff Loeliger                                                  */
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/*                                                                        */
/* UPDATE HISTORY                                                         */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   J. Loeliger  06/Apr/98    Initial version of file.               */
/* 0.2                20/Dec/98    Broke header file into modules.        */
/* 1.0   J. Loeliger  12/Jan/99    Added three ways to create an instance */
/*                                   of the module and added PACK.        */
/* 1.1   J. Loeliger  22/Jun/99    Added ifdef to support C++             */
/*       K. Muto                   Added PAWS field to CMFTST             */
/* 1.2   J. Loeliger  07/Jul/99    Added new bits NVR and GDB to CMFTST.  */
/*                                   These were added to MPC555 rev K1.   */
/**************************************************************************/
#ifndef _MPC555_FLASH_H
#define _MPC555_FLASH_H

#ifndef _MPC555_COMMON_H
#include "M_COMMON.h"
#endif /*  ifndef _MPC555_COMMON_H  */

#ifdef  __cplusplus
extern "C" {
#endif

/****************************************************************************/
/*                              MODULE :FLASH                               */
/****************************************************************************/
    struct CMF_tag {
        union {
            VUINT32 R;
            struct {
                VUINT32 LOCK:1;
                  VUINT32:2;
                VUINT32 FIC:1;
                VUINT32 SIE:1;
                VUINT32 ACCESS:1;
                VUINT32 CENSOR:2;
                VUINT32 SUPV:8;
                VUINT32 DATA:8;
                VUINT32 PROTECT:8;
            } B;
        } CMFMCR;

        union {
            VUINT32 R;
            struct {
                VUINT32:20;
                VUINT32 NVR:1;
                  VUINT32 PAWS:3;
                  VUINT32:2;
                VUINT32 GDB:1;
                  VUINT32:5;
            } B;
        } CMFTST;

        union {
            VUINT32 R;
            struct {
                VUINT32 HVS:1;
                  VUINT32:1;
                VUINT32 SCLKR:3;
                  VUINT32:1;
                VUINT32 CLKPE:2;
                  VUINT32:1;
                VUINT32 CLKPM:7;
                VUINT32 BLOCK:8;
                  VUINT32:1;
                VUINT32 CSC:1;
                VUINT32 EPEE:1;
                  VUINT32:2;
                VUINT32 PE:1;
                VUINT32 SES:1;
                VUINT32 EHV:1;
            } B;
        } CMFCTL;
    };


/******************************************************************/
/* There are three way to create an instance of the CMF module:   */
/* -Use a fixed structure (Default)                               */
/* -Use the Diab compiler sections (if DIAB_SCETIONS is defined)  */
/* -Use a pointer (if HEADER_POINTERS is defined)                 */
/******************************************************************/
#ifdef DIAB_SECTIONS            /* Diab Compiler Only */

#pragma section CMF_A  address=0x2FC800  /* Map modules to fixed addresses. */
#pragma use_section CMF_A CMF_A
    EXT struct CMF_tag CMF_A;

#pragma section CMF_B  address=0x2FC840
#pragma use_section CMF_B CMF_B
    EXT struct CMF_tag CMF_B;

#else
#ifdef HEADER_POINTERS

/* Create a global pointer. */

#ifdef Main_Program
    struct CMF_tag *CMF_A = (struct CMF_tag *) (INTERNAL_MEMORY_BASE + 0x2FC800);
    struct CMF_tag *CMF_B = (struct CMF_tag *) (INTERNAL_MEMORY_BASE + 0x2FC840);
#else
    EXT struct CMF_tag *CMF_A;
    EXT struct CMF_tag *CMF_B;
#endif

#else

/* Use a fixed structure, this is the default */
#define CMF_A  (*( struct CMF_tag *)    (INTERNAL_MEMORY_BASE + 0x2FC800))
#define CMF_B  (*( struct CMF_tag *)    (INTERNAL_MEMORY_BASE + 0x2FC840))

#endif                          /* HEADER_POINTERS */

#endif                          /* DIAB_SECTIONS */

#ifdef  __cplusplus
}

#endif
#endif
/* ifndef _MPC555_FLASH_H  */
/*****************************************************************************/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/


