;**************************************************************************
;*                                            COPYRIGHT (c) MOTOROLA 1998 *
;* FILE NAME: ex_tblc.s                                                   *
;*                                                                        *
;* INCLUDE FILES: none                                                    *
;* VERSION: 1.0                                                           *
;*                                                                        *
;*========================================================================*
;*                                                                        *
;* DESCRIPTION:                                                           *
;* This file contains the reduced size exception table definitions for    *
;* the MPC555 using the exception table relocation feature.               *
;* All exception routines are extern and imported to this file.           *
;*                                                                        *
;*========================================================================*
;*                                                                        *
;* ASSEMBLER: Diab Data        VERSION: 4.1a:1                            *
;*                                                                        *
;* AUTHOR: Jeff Loeliger                   CREATION DATE:   8/Apr/98      *
;* LOCATION: East Kilbride, Scotland.                                     *
;*                                                                        *
;* UPDATE HISTORY                                                         *
;* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
;* ---   -----------  ---------    ---------------------                  *
;* 1.0   J. Loeliger   8/Apr/98    Inital version of file                 *
;*                                                                        *
;**************************************************************************

	.import _start, machine_check_exception, data_access_exception
	.import instruct_access_exception, external_interrupt
	.import alignment_exception, program_exception
	.import fp_unavailable_exception, decrementer_exception
	.import system_call_exception, trace_exception
	.import fp_assist_exception, software_emulation_exception
	.import instruction_protection_exception, data_protection_exception
	.import data_breakpoint, instruct_breakpoint
	.import maskable_external_breakpoint, nonmaskable_external_breakpoint
	.import reserved

	.name "ex_tblc.s"

	.org 0x000			;Reserved this exception should
	b reserved			;never occur

	.org 0x008			;System Reset Exception
	b _start			;This is defined in the crt0.s file

	.org 0x010			;Machine Check Exception
	b machine_check_exception

	.org 0x018			;Data Access Exception
	b data_access_exception

	.org 0x020			;Instruction Access Exception
	b instruct_access_exception

	.org 0x028			;External Interrupt Exception
	b external_interrupt

	.org 0x030			;Alignment Exception
	b alignment_exception

	.org 0x038			;Program Exception
	b program_exception

	.org 0x040			;Floating Point Unavailable Exception
	b fp_unavailable_exception

	.org 0x048			;Decrementer Exception
	b decrementer_exception

	.org 0x050			;Reserved this exception should
	b reserved			;never occur

	.org 0x058			;Reserved this exception should
	b reserved			;never occur

	.org 0x060			;System Call Exception
	b system_call_exception

	.org 0x068			;Trace Exception
	b trace_exception

	.org 0x070			;Floating Point Assist Exception
	b fp_assist_exception

	.org 0x078			;Reserved this exception should
	b reserved			;never occur

	.org 0x080			;Software Emulation Exception
	b software_emulation_exception

	.org 0x088			;Reserved this exception should
	b reserved			;never occur

	.org 0x090			;Reserved this exception should
	b reserved			;never occur

	.org 0x098			;Instruction Protection Exception
	b instruction_protection_exception

	.org 0x0A0			;Data Protection Exception
	b data_protection_exception

	.org 0x0A8			;Reserved this exception should
	b reserved			;never occur

	.org 0x0B0			;Reserved this exception should
	b reserved			;never occur

	.org 0x0B8			;Reserved this exception should
	b reserved			;never occur

	.org 0x0C0			;Reserved this exception should
	b reserved			;never occur

	.org 0x0C8			;Reserved this exception should
	b reserved			;never occur

	.org 0x0D0			;Reserved this exception should
	b reserved			;never occur

	.org 0x0D8			;Reserved this exception should
	b reserved			;never occur

	.org 0x0E0			;Data Breakpoint Exception
	b data_breakpoint

	.org 0x0E8			;Instruction Breakpoint Exception
	b instruct_breakpoint

	.org 0x0F0			;Maskable External Breakpoint
	b maskable_external_breakpoint

	.org 0x0F8			;Nonmaskable External Breakpoint
	b nonmaskable_external_breakpoint

;*****************************************************************************
;* Motorola reserves the right to make changes without further notice to any *
;* product herein to improve reliability, function, or design. Motorola does *
;* not assume any  liability arising  out  of the  application or use of any *
;* product,  circuit, or software described herein;  neither  does it convey *
;* any license under its patent rights  nor the  rights of others.  Motorola *
;* products are not designed, intended,  or authorized for use as components *
;* in  systems  intended  for  surgical  implant  into  the  body, or  other *
;* applications intended to support life, or  for any  other application  in *
;* which the failure of the Motorola product  could create a situation where *
;* personal injury or death may occur. Should Buyer purchase or use Motorola *
;* products for any such intended  or unauthorized  application, Buyer shall *
;* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, *
;* affiliates,  and distributors harmless against all claims costs, damages, *
;* and expenses, and reasonable  attorney  fees arising  out of, directly or *
;* indirectly,  any claim of personal injury  or death  associated with such *
;* unintended or unauthorized use, even if such claim alleges that  Motorola *
;* was negligent regarding the  design  or manufacture of the part. Motorola *
;* and the Motorola logo* are registered trademarks of Motorola Ltd.         *
;*****************************************************************************



