/**************************************************************************/
/* FILE NAME: example3.c                      COPYRIGHT (c) MOTOROLA 1999 */
/* VERSION: 1.1                                   All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION: This file shows how to use the standard set-up and header */
/* files for the MPC555. This program sets up the MPC555 EVB, generates a */
/* 10kHz PWM on the MIOS1 PWM19 channel and generates a software PWM on   */
/* QADC A port A7.                                                        */
/* This program uses the header pointers feature of the header files. To  */
/* use the header pointers you must #define HEADER_POINTERS, this can be  */
/* done by adding an option (-DHEADER_POINTERS) in the makefile.          */
/*========================================================================*/
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/* AUTHOR: Jeff Loeliger                                                  */
/*                                                                        */
/* HISTORY                                                                */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 1.0   J. Loeliger  19/Jan/99    Initial version of function.           */
/* 1.1   J. Loeliger  25/Jun/99    Updated register names.                */
/**************************************************************************/
#define Main_Program

#include "mpc555.h"

void main ()
{
/*************************************************************
 * Set up PWM19 on the MIOS1 module to output a 10KHz signal *
 *************************************************************/

    MIOS1->MCPSMSCR.B.PREN = 1; /* enable MIOS counters */

/* setup PWM19 */
    MIOS1->MPWMSM19PERR.R = 0xfa;  /* set period to 0xfa */

    MIOS1->MPWMSM19PULR.R = 0x3e;  /* set high time to 0x3e */

    MIOS1->MPWMSM19SCR.B.CP = 0xff;  /* set prescaler to 1 */

    MIOS1->MPWMSM19SCR.B.EN = 1;   /* enable output on PWM19 */

/**************************************************
 * Generate a software PWM on QADC A port A7 pin. *
 **************************************************/
    QADC_A->DDRQA.B.DDQA7 = 1;  /* setup QADC A port A7 as output */

    while (1) {                 /* Toggle QADC A port A7 pin */
        QADC_A->PORTQA.B.PQA7 = 1;
        QADC_A->PORTQA.B.PQA7 = 0;
    }
}

/*****************************************************************************/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/
