/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 #ifndef _PIN_MUX_H_
#define _PIN_MUX_H_


/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
  kPIN_MUX_DirectionInput = 0U,         /* Input direction */
  kPIN_MUX_DirectionOutput = 1U,        /* Output direction */
  kPIN_MUX_DirectionInputOrOutput = 2U  /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/*******************************************************************************
 * API
 ******************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif



/* FC0_RXD_SDA_MOSI (coord B13), U24[13]/P0_29-ISP_FC0_RXD */
#define BOARD_INITPINS_ISP_FC0_RXD_PERIPHERAL                          FLEXCOMM0   /*!< Device name: FLEXCOMM0 */
#define BOARD_INITPINS_ISP_FC0_RXD_SIGNAL                           RXD_SDA_MOSI   /*!< FLEXCOMM0 signal: RXD_SDA_MOSI */
#define BOARD_INITPINS_ISP_FC0_RXD_PIN_NAME                     FC0_RXD_SDA_MOSI   /*!< Pin name */
#define BOARD_INITPINS_ISP_FC0_RXD_LABEL             "U24[13]/P0_29-ISP_FC0_RXD"   /*!< Label */
#define BOARD_INITPINS_ISP_FC0_RXD_NAME                            "ISP_FC0_RXD"   /*!< Identifier name */

/* FC0_TXD_SCL_MISO (coord A2), U24[12]/P0_30-ISP_FC0_TXD */
#define BOARD_INITPINS_ISP_FC0_TXD_PERIPHERAL                          FLEXCOMM0   /*!< Device name: FLEXCOMM0 */
#define BOARD_INITPINS_ISP_FC0_TXD_SIGNAL                           TXD_SCL_MISO   /*!< FLEXCOMM0 signal: TXD_SCL_MISO */
#define BOARD_INITPINS_ISP_FC0_TXD_PIN_NAME                     FC0_TXD_SCL_MISO   /*!< Pin name */
#define BOARD_INITPINS_ISP_FC0_TXD_LABEL             "U24[12]/P0_30-ISP_FC0_TXD"   /*!< Label */
#define BOARD_INITPINS_ISP_FC0_TXD_NAME                            "ISP_FC0_TXD"   /*!< Identifier name */

/* ENET_TXD0 (coord B14), U12[17]/JP11[1]/P4_8-ENET_TXD0 */
#define BOARD_INITPINS_ENET_TXD0_PERIPHERAL                                 ENET   /*!< Device name: ENET */
#define BOARD_INITPINS_ENET_TXD0_SIGNAL                                 ENET_TXD   /*!< ENET signal: ENET_TXD */
#define BOARD_INITPINS_ENET_TXD0_CHANNEL                                       0   /*!< ENET ENET_TXD channel: 0 */
#define BOARD_INITPINS_ENET_TXD0_PIN_NAME                              ENET_TXD0   /*!< Pin name */
#define BOARD_INITPINS_ENET_TXD0_LABEL          "U12[17]/JP11[1]/P4_8-ENET_TXD0"   /*!< Label */
#define BOARD_INITPINS_ENET_TXD0_NAME                                "ENET_TXD0"   /*!< Identifier name */

/* ENET_RX_DV (coord B9), U12[11]/P4_10-ENET_CRS_DV */
#define BOARD_INITPINS_ENET_CRS_DV_PERIPHERAL                               ENET   /*!< Device name: ENET */
#define BOARD_INITPINS_ENET_CRS_DV_SIGNAL                             ENET_RX_DV   /*!< ENET signal: ENET_RX_DV */
#define BOARD_INITPINS_ENET_CRS_DV_PIN_NAME                           ENET_RX_DV   /*!< Pin name */
#define BOARD_INITPINS_ENET_CRS_DV_LABEL             "U12[11]/P4_10-ENET_CRS_DV"   /*!< Label */
#define BOARD_INITPINS_ENET_CRS_DV_NAME                            "ENET_CRS_DV"   /*!< Identifier name */

/* ENET_RXD1 (coord A6), U12[7]/P4_12-ENET_RXD1 */
#define BOARD_INITPINS_ENET_RXD1_PERIPHERAL                                 ENET   /*!< Device name: ENET */
#define BOARD_INITPINS_ENET_RXD1_SIGNAL                                 ENET_RXD   /*!< ENET signal: ENET_RXD */
#define BOARD_INITPINS_ENET_RXD1_CHANNEL                                       1   /*!< ENET ENET_RXD channel: 1 */
#define BOARD_INITPINS_ENET_RXD1_PIN_NAME                              ENET_RXD1   /*!< Pin name */
#define BOARD_INITPINS_ENET_RXD1_LABEL                  "U12[7]/P4_12-ENET_RXD1"   /*!< Label */
#define BOARD_INITPINS_ENET_RXD1_NAME                                "ENET_RXD1"   /*!< Identifier name */

/* ENET_TX_EN (coord B6), U12[16]/P4_13-ENET_TX_EN */
#define BOARD_INITPINS_ENET_TX_EN_PERIPHERAL                                ENET   /*!< Device name: ENET */
#define BOARD_INITPINS_ENET_TX_EN_SIGNAL                              ENET_TX_EN   /*!< ENET signal: ENET_TX_EN */
#define BOARD_INITPINS_ENET_TX_EN_PIN_NAME                            ENET_TX_EN   /*!< Pin name */
#define BOARD_INITPINS_ENET_TX_EN_LABEL               "U12[16]/P4_13-ENET_TX_EN"   /*!< Label */
#define BOARD_INITPINS_ENET_TX_EN_NAME                              "ENET_TX_EN"   /*!< Identifier name */

/* ENET_RX_CLK (coord B5), JS18[2]/P4_14-ENET_RX_CLK */
#define BOARD_INITPINS_ENET_RX_CLK_PERIPHERAL                               ENET   /*!< Device name: ENET */
#define BOARD_INITPINS_ENET_RX_CLK_SIGNAL                            ENET_RX_CLK   /*!< ENET signal: ENET_RX_CLK */
#define BOARD_INITPINS_ENET_RX_CLK_PIN_NAME                          ENET_RX_CLK   /*!< Pin name */
#define BOARD_INITPINS_ENET_RX_CLK_LABEL             "JS18[2]/P4_14-ENET_RX_CLK"   /*!< Label */
#define BOARD_INITPINS_ENET_RX_CLK_NAME                            "ENET_RX_CLK"   /*!< Identifier name */

/* ENET_MDC (coord A4), U12[13]/P4_15-ENET_MDC */
#define BOARD_INITPINS_ENET_MDC_PERIPHERAL                                  ENET   /*!< Device name: ENET */
#define BOARD_INITPINS_ENET_MDC_SIGNAL                                  ENET_MDC   /*!< ENET signal: ENET_MDC */
#define BOARD_INITPINS_ENET_MDC_PIN_NAME                                ENET_MDC   /*!< Pin name */
#define BOARD_INITPINS_ENET_MDC_LABEL                   "U12[13]/P4_15-ENET_MDC"   /*!< Label */
#define BOARD_INITPINS_ENET_MDC_NAME                                  "ENET_MDC"   /*!< Identifier name */

/* ENET_MDIO (coord C4), U12[12]/P4_16-ENET_MDIO */
#define BOARD_INITPINS_ENET_MDIO_PERIPHERAL                                 ENET   /*!< Device name: ENET */
#define BOARD_INITPINS_ENET_MDIO_SIGNAL                                ENET_MDIO   /*!< ENET signal: ENET_MDIO */
#define BOARD_INITPINS_ENET_MDIO_PIN_NAME                              ENET_MDIO   /*!< Pin name */
#define BOARD_INITPINS_ENET_MDIO_LABEL                 "U12[12]/P4_16-ENET_MDIO"   /*!< Label */
#define BOARD_INITPINS_ENET_MDIO_NAME                                "ENET_MDIO"   /*!< Identifier name */

/* ENET_TXD1 (coord E14), U12[18]/P0_17-ENET_TXD1 */
#define BOARD_INITPINS_ENET_TXD1_PERIPHERAL                                 ENET   /*!< Device name: ENET */
#define BOARD_INITPINS_ENET_TXD1_SIGNAL                                 ENET_TXD   /*!< ENET signal: ENET_TXD */
#define BOARD_INITPINS_ENET_TXD1_CHANNEL                                       1   /*!< ENET ENET_TXD channel: 1 */
#define BOARD_INITPINS_ENET_TXD1_PIN_NAME                              ENET_TXD1   /*!< Pin name */
#define BOARD_INITPINS_ENET_TXD1_LABEL                 "U12[18]/P0_17-ENET_TXD1"   /*!< Label */
#define BOARD_INITPINS_ENET_TXD1_NAME                                "ENET_TXD1"   /*!< Identifier name */

/* PIO2_26 (coord H11), U12[15]/P2_26-ENET_PHY_RSTn */
#define BOARD_INITPINS_ENET_PHY_RSTn_GPIO                                   GPIO   /*!< GPIO device name: GPIO */
#define BOARD_INITPINS_ENET_PHY_RSTn_PORT                                     2U   /*!< PORT device index: 2 */
#define BOARD_INITPINS_ENET_PHY_RSTn_GPIO_PIN                                26U   /*!< PIO2 pin index: 26 */
#define BOARD_INITPINS_ENET_PHY_RSTn_PIN_NAME                            PIO2_26   /*!< Pin name */
#define BOARD_INITPINS_ENET_PHY_RSTn_LABEL         "U12[15]/P2_26-ENET_PHY_RSTn"   /*!< Label */
#define BOARD_INITPINS_ENET_PHY_RSTn_NAME                        "ENET_PHY_RSTn"   /*!< Identifier name */

/* SWO (coord P2), U16[12]/SWO_TRGT */
#define BOARD_INITPINS_SWO_TRGT_PERIPHERAL                                   SWD   /*!< Device name: SWD */
#define BOARD_INITPINS_SWO_TRGT_SIGNAL                                       SWO   /*!< SWD signal: SWO */
#define BOARD_INITPINS_SWO_TRGT_PIN_NAME                                     SWO   /*!< Pin name */
#define BOARD_INITPINS_SWO_TRGT_LABEL                         "U16[12]/SWO_TRGT"   /*!< Label */
#define BOARD_INITPINS_SWO_TRGT_NAME                                  "SWO_TRGT"   /*!< Identifier name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void); /* Function assigned for the Cortex-M4F */

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/*******************************************************************************
 * EOF
 ******************************************************************************/
