// -------------------------------------------------------------------
// RGB Space Matrices
// - www.brucelindbloom.com
// -------------------------------------------------------------------

/** \file
 * \brief RGB Space Matrices
 */

float RgbSpaceMatrices[] = {
    // 0: Adobe RGB (1998)	D65	
     0.5767309,  0.1855540,  0.1881852,
     0.2973769,  0.6273491,  0.0752741,
     0.0270343,  0.0706872,  0.9911085,
     2.0413690, -0.5649464, -0.3446944,
    -0.9692660,  1.8760108,  0.0415560,
     0.0134474, -0.1183897,  1.0154096,
    // 1: AppleRGB	D65	
     0.4497288,  0.3162486,  0.1844926,
     0.2446525,  0.6720283,  0.0833192,
     0.0251848,  0.1411824,  0.9224628,
     2.9515373, -1.2894116, -0.4738445,
    -1.0851093,  1.9908566,  0.0372026,
     0.0854934, -0.2694964,  1.0912975,
    // 2: Best RGB	D50	
     0.6326696,  0.2045558,  0.1269946,
     0.2284569,  0.7373523,  0.0341908,
     0.0000000,  0.0095142,  0.8156958,
     1.7552599, -0.4836786, -0.2530000,
    -0.5441336,  1.5068789,  0.0215528,
     0.0063467, -0.0175761,  1.2256959,
    // 3: Beta RGB	D50	
     0.6712537,  0.1745834,  0.1183829,
     0.3032726,  0.6637861,  0.0329413,
     0.0000000,  0.0407010,  0.7845090,
     1.6832270, -0.4282363, -0.2360185,
    -0.7710229,  1.7065571,  0.0446900,
     0.0400013, -0.0885376,  1.2723640,
    // 4: Bruce RGB	D65	,
     0.4674162,  0.2944512,  0.1886026,
     0.2410115,  0.6835475,  0.0754410,
     0.0219101,  0.0736128,  0.9933071,
     2.7454669, -1.1358136, -0.4350269,
    -0.9692660,  1.8760108,  0.0415560,
     0.0112723, -0.1139754,  1.0132541,
    // 5: CIE RGB	E	
     0.4887180,  0.3106803,  0.2006017,
     0.1762044,  0.8129847,  0.0108109,
     0.0000000,  0.0102048,  0.9897952,
     2.3706743, -0.9000405, -0.4706338,
    -0.5138850,  1.4253036,  0.0885814,
     0.0052982, -0.0146949,  1.0093968,
    // 6: ColorMatch RGB	D50	
     0.5093439,  0.3209071,  0.1339691,
     0.2748840,  0.6581315,  0.0669845,
     0.0242545,  0.1087821,  0.6921735,
     2.6422874, -1.2234270, -0.3930143,
    -1.1119763,  2.0590183,  0.0159614,
     0.0821699, -0.2807254,  1.4559877,
    // 7: Don RGB, 4	D50	
     0.6457711,  0.1933511,  0.1250978,
     0.2783496,  0.6879702,  0.0336802,
     0.0037113,  0.0179861,  0.8035125,
     1.7603902, -0.4881198, -0.2536126,
    -0.7126288,  1.6527432,  0.0416715,
     0.0078207, -0.0347411,  1.2447743,
    // 8: ECI RGB	D50	
     0.6502043,  0.1780774,  0.1359384,
     0.3202499,  0.6020711,  0.0776791,
     0.0000000,  0.0678390,  0.7573710,
     1.7827618, -0.4969847, -0.2690101,
    -0.9593623,  1.9477962, -0.0275807,
     0.0859317, -0.1744674,  1.3228273,
    // 9: Ekta Space PS5	D50	
     0.5938914,  0.2729801,  0.0973485,
     0.2606286,  0.7349465,  0.0044249,
     0.0000000,  0.0419969,  0.7832131,
     2.0043819, -0.7304844, -0.2450052,
    -0.7110285,  1.6202126,  0.0792227,
     0.0381263, -0.0868780,  1.2725438,
    // 10: NTSC RGB	C	,
     0.6068909,  0.1735011,  0.2003480,
     0.2989164,  0.5865990,  0.1144845,
     0.0000000,  0.0660957,  1.1162243,
     1.9099961, -0.5324542, -0.2882091,
    -0.9846663,  1.9991710, -0.0283082,
     0.0583056, -0.1183781,  0.8975535,
    // 11: PAL/SECAM RGB	D65	
     0.4306190,  0.3415419,  0.1783091,
     0.2220379,  0.7066384,  0.0713236,
     0.0201853,  0.1295504,  0.9390944,
     3.0628971, -1.3931791, -0.4757517,
    -0.9692660,  1.8760108,  0.0415560,
     0.0678775, -0.2288548,  1.0693490,
    // 12: ProPhoto RGB	D50,	
     0.7976749,  0.1351917,  0.0313534,
     0.2880402,  0.7118741,  0.0000857,
     0.0000000,  0.0000000,  0.8252100,
     1.3459433, -0.2556075, -0.0511118,
    -0.5445989,  1.5081673,  0.0205351,
     0.0000000,  0.0000000,  1.2118128,
    // 13: SMPTE-C RGB	D65	
     0.3935891,  0.3652497,  0.1916313,
     0.2124132,  0.7010437,  0.0865432,
     0.0187423,  0.1119313,  0.9581563,
     3.5053960, -1.7394894, -0.5439640,
    -1.0690722,  1.9778245,  0.0351722,
     0.0563200, -0.1970226,  1.0502026,
    // 14: sRGB	D65	
     0.4124564,  0.3575761,  0.1804375,
     0.2126729,  0.7151522,  0.0721750,
     0.0193339,  0.1191920,  0.9503041,
     3.2404542, -1.5371385, -0.4985314,
    -0.9692660,  1.8760108,  0.0415560,
     0.0556434, -0.2040259,  1.0572252,
    // 15: Wide Gamut RGB	D50	
     0.7161046,  0.1009296,  0.1471858,
     0.2581874,  0.7249378,  0.0168748,
     0.0000000,  0.0517813,  0.7734287,
     1.4628067, -0.1840623, -0.2743606,
    -0.5217933,  1.4472381,  0.0677227,
     0.0349342, -0.0968930,  1.2884099,
    // For those RGB working spaces that are not natively D50, the Bradford-adapted, D50 matrices are:
    
    // RGB Working Space	Reference White	RGB to XYZ [M]	XYZ to RGB [M]-1
    // 16: Adobe RGB (1998)	D50	
     0.6097559,  0.2052401,  0.1492240,
     0.3111242,  0.6256560,  0.0632197,
     0.0194811,  0.0608902,  0.7448387,
     1.9624274, -0.6105343, -0.3413404,
    -0.9787684,  1.9161415,  0.0334540,
     0.0286869, -0.1406752,  1.3487655,
    // 17: AppleRGB	D50	
     0.4755678,  0.3396722,  0.1489800,
     0.2551812,  0.6725693,  0.0722496,
     0.0184697,  0.1133771,  0.6933632,
     2.8510695, -1.3605261, -0.4708281,
    -1.0927680,  2.0348871,  0.0227598,
     0.1027403, -0.2964984,  1.4510659,
    // 18: Bruce RGB	D50	,
     0.4941816,  0.3204834,  0.1495550,
     0.2521531,  0.6844869,  0.0633600,
     0.0157886,  0.0629304,  0.7464909,
     2.6502856, -1.2014485, -0.4289936,
    -0.9787684,  1.9161415,  0.0334540,
     0.0264570, -0.1361227,  1.3458542,
    // 19: CIE RGB	D50	
     0.4868870,  0.3062984,  0.1710347,
     0.1746583,  0.8247541,  0.0005877,
    -0.0012563,  0.0169832,  0.8094831,
     2.3638081, -0.8676030, -0.4988161,
    -0.5005940,  1.3962369,  0.1047562,
     0.0141712, -0.0306400,  1.2323842,
    // 20: NTSC RGB	D50	
     0.6343706,  0.1852204,  0.1446290,
     0.3109496,  0.5915984,  0.0974520,
    -0.0011817,  0.0555518,  0.7708399,
     1.8464881, -0.5521299, -0.2766458,
    -0.9826630,  2.0044755, -0.0690396,
     0.0736477, -0.1453020,  1.3018376,
    // 21: PAL/SECAM RGB	D50	
     0.4552773,  0.3675500,  0.1413926,
     0.2323025,  0.7077956,  0.0599019,
     0.0145457,  0.1049154,  0.7057489,
     2.9603944, -1.4678519, -0.4685105,
    -0.9787684,  1.9161415,  0.0334540,
     0.0844874, -0.2545973,  1.4216174,
    // 22: SMPTE-C RGB	D50	
     0.4163290,  0.3931464,  0.1547446,
     0.2216999,  0.7032549,  0.0750452,
     0.0136576,  0.0913604,  0.7201920,
     3.3921940, -1.8264027, -0.5385522,
    -1.0770996,  2.0213975,  0.0207989,
     0.0723073, -0.2217902,  1.3960932,
    // 23: sRGB	D50	
     0.4360747,  0.3850649,  0.1430804,
     0.2225045,  0.7168786,  0.0606169,
     0.0139322,  0.0971045,  0.7141733,
     3.1338561, -1.6168667, -0.4906146,
    -0.9787684,  1.9161415,  0.0334540,
     0.0719453, -0.2289914,  1.4052427
};
    
