/*****************************************************************************
 *
 * MODULE:             JN-AN-1200-ZigBee-RF4CE-Application-Template
 *
 * COMPONENT:          app_buttons.h
 *
 * DESCRIPTION:        Button Initialisation and Read functionality.
 *
 * $HeadURL: https://www.collabnet.nxp.com/svn/lprf_apps/Application_Notes/JN-AN-1158-ZigBee-RF4CE-Demonstration/Branches/CoshipPort_Oct2013/Common/Source/app_buttons.h $
 *
 * $Revision: 12053 $
 *
 * $LastChangedBy: nxp46755 $
 *
 * $LastChangedDate: 2013-12-06 10:51:43 +0530 (Fri, 06 Dec 2013) $
 *
 * $Id: app_buttons.h 12053 2013-12-06 05:21:43Z nxp46755 $
 *
 ****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN516x, JN514x,
 * JN513x].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 *
 ***************************************************************************/

#ifndef APP_BUTTONS_INCLUDED
#define APP_BUTTONS_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/
#include "AppApi_JN516x.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
#if defined(EK001)
    #define APP_BUTTONS_SW1     (11)
    #define APP_BUTTONS_SW2     (12)
    #define APP_BUTTONS_SW3     (17)
    #define APP_BUTTONS_SW4     (1)     /* Do not use the 4th button if example uses UART1 */
    #define APP_BUTTONS_DIO8    (8)

    #define APP_BUTTONS_SW1_MASK    (1 << APP_BUTTONS_SW1)
    #define APP_BUTTONS_SW2_MASK    (1 << APP_BUTTONS_SW2)
    #define APP_BUTTONS_SW3_MASK    (1 << APP_BUTTONS_SW3)
    #define APP_BUTTONS_SW4_MASK    (1 << APP_BUTTONS_SW4)
    #define APP_BUTTONS_DIO8_MASK   (1 << APP_BUTTONS_DIO8)

    #define APP_BUTTONS_DIO_MASK    (APP_BUTTONS_SW1_MASK | \
                                     APP_BUTTONS_SW2_MASK | \
                                     APP_BUTTONS_SW3_MASK | \
                                     APP_BUTTONS_SW4_MASK | \
                                     APP_BUTTONS_DIO8_MASK)

    #define ERR     (0xFF)  /* Key press Error Value*/

    /* For LEDs on EK001 board */
    #define LED_DIO6    (0x00000004UL)
    #define LED_DIO3    (0x00000008UL)

    #define LED3_LOW    do{ \
                            vAHI_DioSetOutput(LED_DIO3,0); \
                          }while(!(u32AHI_DioReadInput() & LED_DIO3))

    #define LED3_HIGH   do{ \
                            vAHI_DioSetOutput(0,LED_DIO3); \
                          }while(u32AHI_DioReadInput() & LED_DIO3)

    #define LED6_LOW    do{ \
                            vAHI_DioSetOutput(LED_DIO6,0); \
                          }while(!(u32AHI_DioReadInput() & LED_DIO6))

    #define LED6_HIGH   do{ \
                            vAHI_DioSetOutput(0,LED_DIO6); \
                          }while(u32AHI_DioReadInput() & LED_DIO6)
#endif // defined(EK001)

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/
PUBLIC bool_t bAppButtonsInitialise(void);
PUBLIC uint32 u32AppButtonsReadMask(void);
PUBLIC uint8  u8AppButtonsRead(void);

/****************************************************************************/
/***        External Variables                                            ***/
/****************************************************************************/

#if defined __cplusplus
}
#endif

#endif /*APP_BUTTONS_INCLUDED*/

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
