/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         OccupancyMonitor MIB Declaration
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* Stack includes */
#include <JIP.h>
#include <AccessFunctions.h>
/* Application common includes */
#include "Address.h"
#include "MibSensor.h"
#include "MibOccupancyMonitor.h"

/****************************************************************************/
/***        MIB structure                                                 ***/
/****************************************************************************/
PUBLIC tsMibOccupancyMonitor sMibOccupancyMonitor =
{
	/* Permament data defaults - may be overridden from flash during initialisation */
	.sPerm.u16Timeout = 300,	/* 5 minutes */
	/* Temporary data defaults */
	.sTemp.u8MaxDevices = MIB_OCCUPANCY_MONITOR_MAX_DEVICES
};

/****************************************************************************/
/***        MIB declaration                                               ***/
/****************************************************************************/
/* Registering MIB ? */
#if MK_REG_MIB_OCCUPANCY_MONITOR

#define DECLARE_MIB
#include "MibOccupancyMonitorDef.h"
JIP_START_DECLARE_MIB(OccupancyMonitorDef, OccupancyMonitor)
JIP_CALLBACK(Mode,        MibOccupancyMonitor_eSetMode,      vGetUint8,      &sMibOccupancyMonitor.sPerm.u8Mode       )
JIP_CALLBACK(Timeout,     MibOccupancyMonitor_eSetTimeout,   vGetUint16,     &sMibOccupancyMonitor.sPerm.u16Timeout   )
JIP_CALLBACK(Occupancy,   MibOccupancyMonitor_eSetOccupancy, vGetUint8,      &sMibOccupancyMonitor.sTemp.u8Occupancy  )
JIP_CALLBACK(Enabled,     NULL,  						     vGetUint32,     &sMibOccupancyMonitor.sTemp.u32Enabled   )
JIP_CALLBACK(Occupied,    NULL,   						     vGetUint32,     &sMibOccupancyMonitor.sTemp.u32Occupied  )
JIP_CALLBACK(Unoccupied,  NULL,   						     vGetUint32,     &sMibOccupancyMonitor.sTemp.u32Unoccupied)
JIP_CALLBACK(MaxDevices,  NULL, 							 vGetUint8,      &sMibOccupancyMonitor.sTemp.u8MaxDevices )
JIP_CALLBACK(DeviceTable, NULL, 							 Table_vGetData, &sMibOccupancyMonitor.sDeviceTable       )
JIP_END_DECLARE_MIB(OccupancyMonitor, hOccupancyMonitor)

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibOccupancyMonitor = &sOccupancyMonitorMib.sMib;

#else

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibOccupancyMonitor = NULL;

#endif

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
