/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         OccupancyConfig MIB Implementation
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* Standard includes */
#include <string.h>
/* SDK includes */
#include <jendefs.h>
/* Hardware includes */
#include <AppHardwareApi.h>
#include <PeripheralRegs.h>
/* Stack includes */
#include <Api.h>
#include <AppApi.h>
#include <JIP.h>
#include <6LP.h>
#include <AccessFunctions.h>
/* JenOS includes */
#include <dbg.h>
#include <dbg_uart.h>
#include <os.h>
#include <pdm.h>
/* Application device includes */
#include "DeviceDefs.h"
#include "Node.h"
#include "Address.h"
#include "MibSensor.h"
#include "MibOccupancyConfig.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Function Prototypes                                     ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Variables                                               ***/
/****************************************************************************/
PRIVATE tsMibOccupancyConfig *psMibOccupancyConfig;

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

/****************************************************************************
 *
 * NAME: MibOccupancyConfig_vInit
 *
 * DESCRIPTION:
 * Initialises data
 *
 ****************************************************************************/
PUBLIC void MibOccupancyConfig_vInit(thJIP_Mib        hMibOccupancyConfigInit,
                         	   tsMibOccupancyConfig *psMibOccupancyConfigInit)
{
    /* Debug */
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONFIG, "\n%sMibOccupancyConfig_vInit() {%d}", acDebugIndent, sizeof(tsMibOccupancyConfig));
    Node_vDebugIndent(DEBUG_MIB_OCCUPANCY_CONFIG);

    /* Valid data pointer ? */
    if (psMibOccupancyConfigInit != (tsMibOccupancyConfig *) NULL)
    {
        /* Take copy of pointer to data */
        psMibOccupancyConfig = psMibOccupancyConfigInit;
        /* Take a copy of the MIB handle */
        psMibOccupancyConfig->hMib = hMibOccupancyConfigInit;

        /* Load Dio mib data */
        (void) PDM_eLoadRecord(&psMibOccupancyConfig->sDesc,
					  		   (uint16)(MIB_ID_OCCUPANCY_CONFIG & 0xFFFF),
                               (void *) &psMibOccupancyConfig->sPerm,
                               sizeof(psMibOccupancyConfig->sPerm),
                               FALSE);
		/* Debug */
		DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONFIG, "\n%sPDM_eLoadRecord(OccupancyConfig) = %d", acDebugIndent, psMibOccupancyConfig->sDesc.eState);
    }
    /* Debug */
    Node_vDebugOutdent(DEBUG_MIB_OCCUPANCY_CONFIG);
}

/****************************************************************************
 *
 * NAME: MibOccupancyConfig_vRegister
 *
 * DESCRIPTION:
 * Registers MIB
 *
 ****************************************************************************/
PUBLIC void MibOccupancyConfig_vRegister(void)
{
    teJIP_Status eStatus;

    /* Debug */
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONFIG, "\n%sMibOccupancyConfig_vRegister()", acDebugIndent);
    Node_vDebugIndent(DEBUG_MIB_OCCUPANCY_CONFIG);

	/* Address not set in flash ? */
	if (psMibOccupancyConfig->sPerm.sStateAddress.s6_addr32[0] == 0 &&
		psMibOccupancyConfig->sPerm.sStateAddress.s6_addr32[1] == 0 &&
		psMibOccupancyConfig->sPerm.sStateAddress.s6_addr32[2] == 0 &&
		psMibOccupancyConfig->sPerm.sStateAddress.s6_addr32[3] == 0)
	{
		/* Set unique group address */
		Address_vBuildGroup(&psMibOccupancyConfig->sPerm.sStateAddress,
											  (MAC_ExtAddr_s *) pvAppApiGetMacAddrLocation(),
											  (uint16)(MIB_ID_OCCUPANCY_CONFIG & 0xffff));
	}

    /* Register MIB */
    eStatus = eJIP_RegisterMib(psMibOccupancyConfig->hMib);
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONFIG, "\n%seJIP_RegisterMib(OccupancyConfig) = %d", acDebugIndent, eStatus);

    /* Make sure permament data is saved */
    PDM_vSaveRecord(&psMibOccupancyConfig->sDesc);
    /* Debug */
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONFIG, "\n%sPDM_vSaveRecord(OccupancyConfig) = %d", acDebugIndent, psMibOccupancyConfig->sDesc.eState);

    /* Debug */
    Node_vDebugOutdent(DEBUG_MIB_OCCUPANCY_CONFIG);
}

/****************************************************************************
 *
 * NAME: MibOccupancyConfig_eSetUint8
 *
 * DESCRIPTION:
 * Generic set data callback
 *
 ****************************************************************************/
PUBLIC teJIP_Status MibOccupancyConfig_eSetUint8(uint8 u8Val, void *pvCbData)
{
	teJIP_Status eReturn;

	/* Call standard function */
	eReturn = eSetUint8(u8Val, pvCbData);

    /* Make sure permament data is saved */
    PDM_vSaveRecord(&psMibOccupancyConfig->sDesc);
    /* Debug */
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONFIG, "\n%sPDM_vSaveRecord(OccupancyConfig)");

	return eReturn;
}

/****************************************************************************
 *
 * NAME: MibOccupancyConfig_eSetUint16
 *
 * DESCRIPTION:
 * Generic set data callback
 *
 ****************************************************************************/
PUBLIC teJIP_Status MibOccupancyConfig_eSetUint16(uint16 u16Val, void *pvCbData)
{
	teJIP_Status eReturn;

	/* Call standard function */
	eReturn = eSetUint16(u16Val, pvCbData);

    /* Make sure permament data is saved */
    PDM_vSaveRecord(&psMibOccupancyConfig->sDesc);
    /* Debug */
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONFIG, "\n%sPDM_vSaveRecord(OccupancyConfig)");

	return eReturn;
}

/****************************************************************************
 *
 * NAME: MibOccupancyConfig_eSetUint32
 *
 * DESCRIPTION:
 * Generic set data callback
 *
 ****************************************************************************/
PUBLIC teJIP_Status MibOccupancyConfig_eSetUint32(uint32 u32Val, void *pvCbData)
{
	teJIP_Status eReturn;

	/* Call standard function */
	eReturn = eSetUint32(u32Val, pvCbData);

    /* Make sure permament data is saved */
    PDM_vSaveRecord(&psMibOccupancyConfig->sDesc);
    /* Debug */
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONFIG, "\n%sPDM_vSaveRecord(OccupancyConfig)");

	return eReturn;
}

/****************************************************************************
 *
 * NAME: MibOccupancyConfig_eSetAddress
 *
 * DESCRIPTION:
 * Handle remote set of a group address
 *
 ****************************************************************************/
PUBLIC teJIP_Status MibOccupancyConfig_eSetAddress(const uint8 *pu8Val, uint8 u8Len, void *pvCbData)

{
	teJIP_Status eReturn;

	/* Call helper function */
	eReturn = Address_eSet(pu8Val, u8Len, pvCbData);

	/* Success ? */
	if (eReturn == E_JIP_OK)
	{
	    /* Make sure permament data is saved */
	    PDM_vSaveRecord(&psMibOccupancyConfig->sDesc);
	    /* Debug */
	    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONFIG, "\n%sPDM_vSaveRecord(OccupancyConfig)");
	}

	return eReturn;
}

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
