/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         OccupancyMonitor MIB Interface
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBOCCUPANCYMONITOR_H_INCLUDED
#define  MIBOCCUPANCYMONITOR_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* JenOS includes */
#include <os.h>
#include <pdm.h>
/* Application common includes */
#include "Table.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
#define MIB_OCCUPANCY_MONITOR_MAX_DEVICES					16

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/* Illuminance configuration permament data */
typedef struct
{
	/* Config MIB variable data */
	uint8				u8Mode;
	uint16			   u16Timeout;

}  tsMibOccupancyMonitorPerm;

/* Illuminance configuration temporary data */
typedef struct
{
	/* Config MIB variable data */
   	uint8 			    u8Occupancy;
	uint32			   u32Enabled;
	uint32			   u32Occupied;
	uint32			   u32Unoccupied;
	uint8			    u8MaxDevices;
	in6_addr  			asDeviceTable[MIB_OCCUPANCY_MONITOR_MAX_DEVICES];
} tsMibOccupancyMonitorTemp;

/* Illuminance configuration mib */
typedef struct
{
	/* MIB handle */
	thJIP_Mib 	hMib;

	/* Table handle */
   	tsTable sDeviceTable;

	/* PDM record descriptor */
	PDM_tsRecordDescriptor sDesc;

	/* Data pointers */
	tsMibOccupancyMonitorPerm sPerm;
	tsMibOccupancyMonitorTemp sTemp;

	/* Other data */
   	in6_addr		     		 sIn6AddressNull;
   	uint32 					     au32TimerSeconds[MIB_OCCUPANCY_MONITOR_MAX_DEVICES];
   	uint32						  u32NotifyChanged;

} tsMibOccupancyMonitor;

/****************************************************************************/
/***        Public Function Prototypes                                    ***/
/****************************************************************************/
PUBLIC void 		MibOccupancyMonitor_vInit(thJIP_Mib         hMibOccupancyMonitorInit,
						   				tsMibOccupancyMonitor *psMibOccupancyMonitorInit);
PUBLIC void 		MibOccupancyMonitor_vRegister(void);
PUBLIC void 		MibOccupancyMonitor_vTick(void);
PUBLIC void 		MibOccupancyMonitor_vSecond(uint32 u32TimerSeconds);
PUBLIC uint8 		MibOccupancyMonitor_u8FindDevice(in6_addr *psIn6Address);
PUBLIC teJIP_Status MibOccupancyMonitor_eSetMode(uint8 u8Val, void *pvCbData);
PUBLIC teJIP_Status MibOccupancyMonitor_eSetTimeout(uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status MibOccupancyMonitor_eSetOccupancy(uint8 u8Val, void *pvCbData);

#if defined __cplusplus
}
#endif

#endif  /* MIBILLUMINANCESCENE_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
