/****************************************************************************/
/*\PROJECT 		JN-AN-1162 JenNet-IP Smart Home								*/
/*!
 *\MODULE 		MibColour
 *
 *\FILE			MibColourConfigDec.c
 *
 *\DESCRIPTION	ColourConfig MIB declaration
 *
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* Stack includes */
#include <JIP.h>
#include <AccessFunctions.h>
/* Application common includes */
#include "DeviceDefs.h"
#include "MibColour.h"
#include "MibColourConfig.h"
/* Application colour conversion includes */
#include "ColourConversion.h"

/****************************************************************************/
/***        MIB structure                                                 ***/
/****************************************************************************/
PUBLIC tsMibColourConfig sMibColourConfig = /*!< ColourConfig MIB structure */
{
	/* Permament data defaults - may be overridden from flash during initialisation */
	.sPerm.u16TransitionTime        = MIB_COLOUR_CONFIG_TRANS_TIME_DEFAULT,
	.sPerm.u16CctMin                = 15,
	.sPerm.u16CctMax                = 1000
};

/****************************************************************************/
/***        MIB declaration                                                ***/
/****************************************************************************/
/* Registering MIB ? */
#if MK_REG_MIB_COLOUR_CONFIG

#define DECLARE_MIB
#include "MibColourConfigDef.h"

JIP_START_DECLARE_MIB(ColourConfigDef, ColourConfig)
JIP_CALLBACK(TransitionTime, MibColourConfig_eSetTransitionTime, vGetUint16, &sMibColourConfig.sPerm.u16TransitionTime)
JIP_CALLBACK(InitMode	   , MibColourConfig_eSetInitMode ,      vGetUint8 , &sMibColourConfig.sPerm.u8InitMode	      )
JIP_CALLBACK(InitXYTarget  , MibColourConfig_eSetInitXYTarget,   vGetUint32, &sMibColourConfig.sPerm.u32InitXYTarget  )
JIP_CALLBACK(XYPrimaryWhite, MibColourConfig_eSetPrimary,        vGetUint32, &sMibColourConfig.sPerm.u32XYPrimaryWhite)
JIP_CALLBACK(XYPrimary1	   , MibColourConfig_eSetPrimary,        vGetUint32, &sMibColourConfig.sPerm.u32XYPrimary1    )
JIP_CALLBACK(XYPrimary2	   , MibColourConfig_eSetPrimary,        vGetUint32, &sMibColourConfig.sPerm.u32XYPrimary2    )
JIP_CALLBACK(XYPrimary3	   , MibColourConfig_eSetPrimary,        vGetUint32, &sMibColourConfig.sPerm.u32XYPrimary3    )
JIP_CALLBACK(XYPrimary4	   , MibColourConfig_eSetPrimary,        vGetUint32, &sMibColourConfig.sPerm.u32XYPrimary4    )
JIP_CALLBACK(XYPrimary5	   , MibColourConfig_eSetPrimary,        vGetUint32, &sMibColourConfig.sPerm.u32XYPrimary5    )
JIP_CALLBACK(XYPrimary6	   , MibColourConfig_eSetPrimary,        vGetUint32, &sMibColourConfig.sPerm.u32XYPrimary6    )
JIP_CALLBACK(CctMin	       , MibColourConfig_eSetCct,            vGetUint16, &sMibColourConfig.sPerm.u16CctMin        )
JIP_CALLBACK(CctMax	       , MibColourConfig_eSetCct,            vGetUint16, &sMibColourConfig.sPerm.u16CctMax        )
JIP_END_DECLARE_MIB(ColourConfig, hColourConfig)

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibColourConfig = &sColourConfigMib.sMib; /*< ColourConfig MIB handle */

/* Not registering MIB ? */
#else

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibColourConfig = NULL;

#endif
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
