/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         Interpolation Interface
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  INTERPOLATION_H_INCLUDED
#define  INTERPOLATION_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* Standard includes */
#include <string.h>
#include <stdlib.h>
#include <math.h>
/* SDK includes */
#include <jendefs.h>
/* Application includes */
#include "DeviceDefs.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
#define DIMENSIONS_MAX 3

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
typedef struct
{
	/* Diagnostic data */
	char     acName[16];

	/* Input data */
	uint32 au32Source[DIMENSIONS_MAX];
	uint32 au32Target[DIMENSIONS_MAX];
	uint8    u8StepsPowerOfTwo;
	uint32  u32Steps;
	uint8    u8Dimensions;
	uint8    u8Bits;
	bool_t    bForced;

	/* Output data */
	uint32 au32SourceStep[DIMENSIONS_MAX];
	uint32 au32TargetStep[DIMENSIONS_MAX];
	uint32  u32RemainingSteps;

	/* Internal data */
	uint32  au32ScaledCumulativeDiff[DIMENSIONS_MAX];
	uint32  au32ScaledStepDiff[DIMENSIONS_MAX];
	uint8    u8Scale;

} tsInterpolation;

/****************************************************************************/
/***        Public Function Prototypes                                    ***/
/****************************************************************************/
PUBLIC bool_t Interpolation_bStart      (tsInterpolation *psInterpolation);
PUBLIC bool_t Interpolation_bInterpolate(tsInterpolation *psInterpolation);
PUBLIC bool_t Interpolation_bEnd        (tsInterpolation *psInterpolation);

#if defined __cplusplus
}
#endif

#endif  /* INTERPOLATION_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
